/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportedAttributeType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataSetBean;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.api.model.metadata.TargetBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.ReportedAttributeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.TargetBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataReportBeanImpl
extends SDMXBeanImpl
implements MetadataReportBean {
    private static final long serialVersionUID = 4729253989941473368L;
    private TargetBean _target;
    private List<ReportedAttributeBean> _reportedAttributes = new ArrayList<ReportedAttributeBean>();
    private String id;

    public MetadataReportBeanImpl(MetadataSetBean parent, ReportType bean) {
        super(SDMX_STRUCTURE_TYPE.METADATA_REPORT, (SDMXBean)parent);
        this.id = bean.getId();
        if (bean.getTarget() != null) {
            this._target = new TargetBeanImpl(this, bean.getTarget());
        }
        if (bean.getAttributeSet() != null && ObjectUtil.validCollection(bean.getAttributeSet().getReportedAttributeList())) {
            this._reportedAttributes.clear();
            for (ReportedAttributeType each : bean.getAttributeSet().getReportedAttributeList()) {
                this._reportedAttributes.add(new ReportedAttributeBeanImpl(this, each));
            }
        }
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString(this.id)) {
            throw new ValidationException("Metadata Report must have an Id");
        }
        if (this._target == null) {
            throw new ValidationException("Metadata Report must have a Target");
        }
        if (!ObjectUtil.validCollection(this._reportedAttributes)) {
            throw new ValidationException("Metadata Report must have at least one Reported Attribute");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public TargetBean getTarget() {
        return this._target;
    }

    @Override
    public List<ReportedAttributeBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeBean>(this._reportedAttributes);
    }
}

