/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.base;

import java.util.Date;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimeRangeValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TimeRangeBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TimeRangeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TimeRangeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.MutableBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;

public class TimeRangeMutableBeanImpl
extends MutableBeanImpl
implements TimeRangeMutableBean {
    private static final long serialVersionUID = -1105081442071478375L;
    private Date startDate;
    private Date endDate;
    private boolean isRange;
    private boolean isStartInclusive;
    private boolean isEndInclusive;

    public TimeRangeMutableBeanImpl(TimeRangeBean immutable) {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE);
        if (immutable.getStartDate() != null) {
            this.startDate = immutable.getStartDate().getDate();
        }
        if (immutable.getEndDate() != null) {
            this.endDate = immutable.getEndDate().getDate();
        }
        this.isRange = immutable.isRange();
        this.isStartInclusive = immutable.isStartInclusive();
        this.isEndInclusive = immutable.isEndInclusive();
    }

    public TimeRangeMutableBeanImpl(TimeRangeValueType type) {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE);
        if (type.getAfterPeriod() != null) {
            this.isRange = false;
            this.endDate = DateUtil.formatDate(type.getAfterPeriod().getObjectValue(), true);
            this.isEndInclusive = type.getAfterPeriod().getIsInclusive();
        }
        if (type.getBeforePeriod() != null) {
            this.isRange = false;
            this.startDate = DateUtil.formatDate(type.getBeforePeriod().getObjectValue(), true);
            this.isStartInclusive = type.getBeforePeriod().getIsInclusive();
        }
        if (type.getStartPeriod() != null) {
            this.isRange = true;
            this.startDate = DateUtil.formatDate(type.getStartPeriod().getObjectValue(), true);
            this.isStartInclusive = type.getStartPeriod().getIsInclusive();
        }
        if (type.getEndPeriod() != null) {
            this.isRange = true;
            this.startDate = DateUtil.formatDate(type.getEndPeriod().getObjectValue(), true);
            this.isEndInclusive = type.getEndPeriod().getIsInclusive();
        }
        this.validate();
    }

    private void validate() throws ValidationException {
        if (this.startDate == null && this.endDate == null) {
            throw new ValidationException("Time period must define at least one date");
        }
        if (this.isRange) {
            if (this.startDate == null || this.endDate == null) {
                throw new ValidationException("Time period with a range requires both a start and end period");
            }
            if (this.startDate.getTime() > this.endDate.getTime()) {
                throw new ValidationException("Time range can not specify start period after end period");
            }
        } else if (this.startDate != null && this.endDate != null) {
            throw new ValidationException("Time period can not define both a before period and after period");
        }
    }

    @Override
    public boolean isRange() {
        return this.isRange;
    }

    @Override
    public void setIsRange(boolean isRange) {
        this.isRange = isRange;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate != null) {
            return new Date(this.startDate.getTime());
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate != null) {
            return new Date(this.endDate.getTime());
        }
        return null;
    }

    @Override
    public boolean isStartInclusive() {
        return this.isStartInclusive;
    }

    @Override
    public boolean isEndInclusive() {
        return this.isEndInclusive;
    }

    @Override
    public void setStartDate(Date start) {
        this.startDate = start;
    }

    @Override
    public void setEndDate(Date end) {
        this.endDate = end;
    }

    @Override
    public void setIsStartInclusive(boolean includeStart) {
        this.isStartInclusive = includeStart;
    }

    @Override
    public void setIsEndInclusive(boolean includeEnd) {
        this.isEndInclusive = includeEnd;
    }

    @Override
    public TimeRangeBean createImmutableInstance(SdmxStructureBean parent) {
        return new TimeRangeBeanImpl(this, parent);
    }
}

