/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.ComponentMutableBeanImpl;

public class AttributeMutableBeanImpl
extends ComponentMutableBeanImpl
implements AttributeMutableBean {
    private static final long serialVersionUID = -4692032103270271465L;
    private ATTRIBUTE_ATTACHMENT_LEVEL attachmentLevel;
    private String assignmentStatus;
    private String attachmentGroup;
    private List<String> dimensionReference = new ArrayList<String>();
    private String primaryMeasureReference;
    private List<StructureReferenceBean> conceptRoles = new ArrayList<StructureReferenceBean>();

    public AttributeMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.DATA_ATTRIBUTE);
    }

    public AttributeMutableBeanImpl(AttributeBean bean) {
        super(bean);
        this.attachmentLevel = bean.getAttachmentLevel();
        this.assignmentStatus = bean.getAssignmentStatus();
        this.attachmentGroup = bean.getAttachmentGroup();
        this.dimensionReference = bean.getDimensionReferences();
        this.primaryMeasureReference = bean.getPrimaryMeasureReference();
        if (bean.getConceptRoles() != null) {
            for (CrossReferenceBean currentConceptRole : bean.getConceptRoles()) {
                this.conceptRoles.add(currentConceptRole.createMutableInstance());
            }
        }
    }

    @Override
    public void addConceptRole(StructureReferenceBean sRef) {
        if (this.conceptRoles == null) {
            this.conceptRoles = new ArrayList<StructureReferenceBean>();
        }
        this.conceptRoles.add(sRef);
    }

    @Override
    public List<StructureReferenceBean> getConceptRoles() {
        return this.conceptRoles;
    }

    @Override
    public void setConceptRoles(List<StructureReferenceBean> conceptRoles) {
        this.conceptRoles = conceptRoles;
    }

    @Override
    public ATTRIBUTE_ATTACHMENT_LEVEL getAttachmentLevel() {
        return this.attachmentLevel;
    }

    @Override
    public void setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL attachmentLevel) {
        this.attachmentLevel = attachmentLevel;
    }

    @Override
    public String getAssignmentStatus() {
        return this.assignmentStatus;
    }

    @Override
    public void setAssignmentStatus(String assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
    }

    @Override
    public String getAttachmentGroup() {
        return this.attachmentGroup;
    }

    @Override
    public void setAttachmentGroup(String attachmentGroup) {
        this.attachmentGroup = attachmentGroup;
    }

    @Override
    public List<String> getDimensionReferences() {
        return this.dimensionReference;
    }

    @Override
    public void setDimensionReferences(List<String> dimensionReference) {
        this.dimensionReference = dimensionReference;
    }

    @Override
    public String getPrimaryMeasureReference() {
        return this.primaryMeasureReference;
    }

    @Override
    public void setPrimaryMeasureReference(String primaryMeasureReference) {
        this.primaryMeasureReference = primaryMeasureReference;
    }
}

