/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.ComponentMutableBeanImpl;

public class DimensionMutableBeanImpl
extends ComponentMutableBeanImpl
implements DimensionMutableBean {
    private static final long serialVersionUID = 1L;
    private boolean measureDimension;
    private boolean frequencyDimension;
    private boolean timeDimension;
    private List<StructureReferenceBean> conceptRole = new ArrayList<StructureReferenceBean>();

    public DimensionMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.DIMENSION);
    }

    public DimensionMutableBeanImpl(DimensionBean bean) {
        super(bean);
        this.measureDimension = bean.isMeasureDimension();
        this.frequencyDimension = bean.isFrequencyDimension();
        this.timeDimension = bean.isTimeDimension();
        if (bean.getConceptRole() != null) {
            for (CrossReferenceBean currentConceptRole : bean.getConceptRole()) {
                this.conceptRole.add(currentConceptRole.createMutableInstance());
            }
        }
    }

    @Override
    public boolean isMeasureDimension() {
        return this.measureDimension;
    }

    @Override
    public boolean isFrequencyDimension() {
        return this.frequencyDimension;
    }

    @Override
    public void setFrequencyDimension(boolean bool) {
        this.frequencyDimension = bool;
    }

    @Override
    public void setMeasureDimension(boolean bool) {
        if (bool) {
            this.structureType = SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION;
        }
        this.measureDimension = bool;
    }

    @Override
    public boolean isTimeDimension() {
        return this.timeDimension;
    }

    @Override
    public void setTimeDimension(boolean timeDimension) {
        if (timeDimension) {
            this.structureType = SDMX_STRUCTURE_TYPE.TIME_DIMENSION;
        }
        this.timeDimension = timeDimension;
    }

    @Override
    public List<StructureReferenceBean> getConceptRole() {
        return this.conceptRole;
    }

    @Override
    public void setConceptRole(List<StructureReferenceBean> conceptRole) {
        this.conceptRole = conceptRole;
    }
}

