/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistRefBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchyBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.HierarchicalCodeSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.IdentifiableSuperBeanImpl;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;

public class CodeRefSuperBeanImpl
extends IdentifiableSuperBeanImpl
implements HierarchicalCodeSuperBean {
    private static final long serialVersionUID = 328066827956232466L;
    private CodeBean codeBean;
    private List<HierarchicalCodeSuperBean> codeRefs;

    public CodeRefSuperBeanImpl(HierarchyBean hierarchyBean, HierarchicalCodeBean codeRef, List<CodelistBean> codelists) {
        super(codeRef);
        this.codeBean = this.getCodeBean(hierarchyBean, codeRef, codelists);
        if (codeRef.getCodeRefs() != null) {
            this.codeRefs = new ArrayList<HierarchicalCodeSuperBean>();
            for (HierarchicalCodeBean currentCodeRef : codeRef.getCodeRefs()) {
                this.codeRefs.add(new CodeRefSuperBeanImpl(hierarchyBean, currentCodeRef, codelists));
            }
        }
    }

    private CodeBean getCodeBean(HierarchyBean hierarchyBean, HierarchicalCodeBean codeRef, List<CodelistBean> codelists) {
        CrossReferenceBean sRef = null;
        if (codeRef.getCodeReference() != null) {
            sRef = codeRef.getCodeReference();
        } else {
            HierarchicalCodelistBean hcl = hierarchyBean.getMaintainableParent();
            CodelistRefBean codelistRef = this.getCodelistRef(hcl.getCodelistRef(), codeRef.getCodelistAliasRef());
            sRef = codelistRef.getCodelistReference();
        }
        CodelistBean codelist = (CodelistBean)MaintainableUtil.resolveReference(codelists, sRef);
        if (codelist == null) {
            throw new IllegalArgumentException("Codelist " + sRef.getMaintainableUrn() + " Not found");
        }
        return this.getCode(codelist, sRef.getChildReference().getId());
    }

    private CodeBean getCode(CodelistBean codelist, String codeId) {
        for (CodeBean currentCode : codelist.getItems()) {
            if (!currentCode.getId().equals(codeId)) continue;
            return currentCode;
        }
        throw new IllegalArgumentException("Code " + codeId + " Not found in codelist : " + codelist.getUrn());
    }

    private CodelistRefBean getCodelistRef(List<CodelistRefBean> codelistRefs, String codelistaliasRef) {
        for (CodelistRefBean codelistref : codelistRefs) {
            if (!codelistref.getAlias().equals(codelistaliasRef)) continue;
            return codelistref;
        }
        throw new IllegalArgumentException("Codelist Ref Not found with Alias : " + codelistaliasRef);
    }

    @Override
    public CodeBean getCode() {
        return this.codeBean;
    }

    @Override
    public List<HierarchicalCodeSuperBean> getCodeRefs() {
        if (this.codeRefs == null) {
            return null;
        }
        return new ArrayList<HierarchicalCodeSuperBean>(this.codeRefs);
    }
}

