/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportStructureBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.MetadataReportSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.ReportedAttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.TargetSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.SuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata.ReportedAttributeSuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata.TargetSuperBeanImpl;

public class MetadataReportSuperBeanImpl
extends SuperBeanImpl
implements MetadataReportSuperBean {
    private static final long serialVersionUID = 212629478840566281L;
    private TargetSuperBean target;
    private List<ReportedAttributeSuperBean> reportedAttributes = new ArrayList<ReportedAttributeSuperBean>();
    private MetadataReportBean builtFrom;

    public MetadataReportSuperBeanImpl(ReportStructureBean rs, MetadataReportBean builtFrom, IdentifiableRetrievalManager retrievalManager) {
        super(builtFrom);
        this.builtFrom = builtFrom;
        this.target = new TargetSuperBeanImpl(builtFrom.getTarget(), retrievalManager);
        for (ReportedAttributeBean currentRA : builtFrom.getReportedAttributes()) {
            MetadataAttributeBean maBean = this.getMetadataAttributeForRepotedAttribute(currentRA, rs.getMetadataAttributes());
            this.reportedAttributes.add(new ReportedAttributeSuperBeanImpl(maBean, currentRA, retrievalManager));
        }
    }

    private MetadataAttributeBean getMetadataAttributeForRepotedAttribute(ReportedAttributeBean reportedAttribute, List<MetadataAttributeBean> mAttributeBeans) {
        for (MetadataAttributeBean currentMAttribute : mAttributeBeans) {
            if (!currentMAttribute.getId().equals(reportedAttribute.getId())) continue;
            return currentMAttribute;
        }
        throw new ReferenceException("Can not find reference to metadata attribute with id " + reportedAttribute.getId());
    }

    @Override
    public String getId() {
        return this.builtFrom.getId();
    }

    @Override
    public TargetSuperBean getTarget() {
        return this.target;
    }

    @Override
    public List<ReportedAttributeSuperBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeSuperBean>(this.reportedAttributes);
    }

    @Override
    public MetadataReportBean getBuiltFrom() {
        return this.builtFrom;
    }
}

