/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.query.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.query.AndType;
import org.sdmx.resources.sdmxml.schemas.v20.query.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.query.DataWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.query.OrType;
import org.sdmx.resources.sdmxml.schemas.v20.query.QueryType;
import org.sdmx.resources.sdmxml.schemas.v20.query.TimeType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.base.SdmxDate;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelectionGroup;
import org.sdmxsource.sdmx.sdmxbeans.exception.ModelException;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQueryDimensionSelectionImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQueryImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQuerySelectionGroupImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class DataQueryBuilderV2 {
    public List<DataQuery> buildDataQuery(QueryType queryType, SdmxBeanRetrievalManager structureRetrievalManager) {
        ArrayList<DataQuery> returnList = new ArrayList<DataQuery>();
        for (DataWhereType dataWhere : queryType.getDataWhereList()) {
            returnList.add(this.buildDataQuery(dataWhere, structureRetrievalManager));
        }
        return returnList;
    }

    public DataQuery buildDataQuery(DataWhereType dataWhereType, SdmxBeanRetrievalManager structureRetrievalManager) {
        return new DataQueryProcessor().buildDataQuery(dataWhereType, structureRetrievalManager);
    }

    private class DataQueryProcessor {
        private Set<DataQuerySelectionGroup> dataQuerySelectionGroups = new HashSet<DataQuerySelectionGroup>();
        private String keyFamilyId;
        private String dataflowId;
        private String agencyId;
        private String version;

        private DataQueryProcessor() {
        }

        private DataQuery buildDataQuery(DataWhereType dataWhereType, SdmxBeanRetrievalManager structureRetrievalManager) {
            if (structureRetrievalManager == null) {
                throw new RuntimeException("DataQueryBuilder expectes a SdmxBeanRetrievalManager");
            }
            this.processDataWhere(dataWhereType);
            this.processAnd(dataWhereType.getAnd());
            MaintainableRefBeanImpl flowRef = new MaintainableRefBeanImpl(this.agencyId, this.dataflowId, this.version);
            DataflowBean dataflow = structureRetrievalManager.getDataflow(flowRef);
            if (dataflow == null) {
                throw new RuntimeException("Dataflow not found: " + flowRef);
            }
            MaintainableRefBean dsdRef = dataflow.getDataStructureRef().getMaintainableReference();
            DataStructureBean dataStructureBean = structureRetrievalManager.getDataStructure(dsdRef);
            if (dataStructureBean == null) {
                throw new RuntimeException("Data Structure not found: " + dataflow.getDataStructureRef());
            }
            return new DataQueryImpl(dataStructureBean, null, null, null, true, null, dataflow, null, this.dataQuerySelectionGroups);
        }

        private void processDataWhere(DataWhereType dwType) {
            DataQueryDimensionSelectionImpl newSelection;
            HashSet<DataQuerySelection> selections = new HashSet<DataQuerySelection>();
            SdmxDate dateFrom = null;
            SdmxDate dateTo = null;
            this.dataflowId = dwType.getDataflow();
            this.keyFamilyId = dwType.getKeyFamily();
            this.version = dwType.getVersion();
            if (dwType.getTime() != null) {
                Time t = new Time(dwType.getTime());
                dateFrom = t.dateFrom;
                dateTo = t.dateTo;
            }
            if (dwType.getDimension() != null) {
                newSelection = new DataQueryDimensionSelectionImpl(dwType.getDimension().getId(), dwType.getDimension().getStringValue());
                selections.add(newSelection);
            }
            if (dwType.getAttribute() != null) {
                newSelection = new DataQueryDimensionSelectionImpl(dwType.getAttribute().getId(), dwType.getAttribute().getStringValue());
                selections.add(newSelection);
            }
            this.processOr(dwType.getOr(), selections);
            this.addGroupIfSelectionsExist(selections, dateFrom, dateTo);
        }

        private void addGroupIfSelectionsExist(Set<DataQuerySelection> selections, SdmxDate dateFrom, SdmxDate dateTo) {
            if (ObjectUtil.validCollection(selections) || dateFrom != null || dateTo != null) {
                this.dataQuerySelectionGroups.add(new DataQuerySelectionGroupImpl(selections, dateFrom, dateTo));
            }
        }

        private void processAnd(AndType andType) {
            HashSet<DataQuerySelection> selections = new HashSet<DataQuerySelection>();
            SdmxDate dateFrom = null;
            SdmxDate dateTo = null;
            if (andType != null) {
                if (ObjectUtil.validCollection(andType.getAndList())) {
                    throw new UnsupportedException(new Object[]{"DataWhere.AND followed by AND is not supported"});
                }
                if (andType.getDimensionList() != null) {
                    for (DimensionType currentDimension : andType.getDimensionList()) {
                        for (DataQuerySelection selection : selections) {
                            if (!selection.getComponentId().equals(currentDimension.getId())) continue;
                            throw new ModelException(ExceptionCode.QUERY_SELECTION_ILLEGAL_AND_CODES_IN_SAME_DIMENSION, currentDimension.getId());
                        }
                        this.addComponentSelection(selections, currentDimension.getId(), currentDimension.getStringValue());
                    }
                }
                if (andType.getAttributeList() != null) {
                    for (AttributeType currentAttribute : andType.getAttributeList()) {
                        for (DataQuerySelection selection : selections) {
                            if (!selection.getComponentId().equals(currentAttribute.getId())) continue;
                            throw new ModelException(ExceptionCode.QUERY_SELECTION_ILLEGAL_AND_CODES_IN_SAME_DIMENSION, currentAttribute.getId());
                        }
                        this.addComponentSelection(selections, currentAttribute.getId(), currentAttribute.getStringValue());
                    }
                }
                if (andType.getTimeList() != null) {
                    if (andType.getTimeList().size() > 1) {
                        throw new UnsupportedException(new Object[]{"Multiple Time selection on DataWhere.And not supported"});
                    }
                    for (TimeType time : andType.getTimeList()) {
                        Time t = new Time(time);
                        dateFrom = t.dateFrom;
                        dateTo = t.dateTo;
                    }
                }
                if (ObjectUtil.validCollection(andType.getAgencyIDList())) {
                    if (andType.getAgencyIDList().size() > 1) {
                        throw new ModelException(ExceptionCode.QUERY_SELECTION_ILLEGAL_AND_AGENCY_ID, new Object[0]);
                    }
                    if (this.agencyId != null && !andType.getAgencyIDList().get(0).equals(this.agencyId)) {
                        throw new ValidationException("Multiple agency Ids not supported on DataWhere - got '" + this.agencyId + "' and '" + andType.getAgencyIDList().get(0) + "'");
                    }
                    this.agencyId = andType.getAgencyIDList().get(0);
                }
                if (ObjectUtil.validCollection(andType.getKeyFamilyList())) {
                    if (andType.getKeyFamilyList().size() > 1) {
                        throw new ModelException(ExceptionCode.QUERY_SELECTION_ILLEGAL_AND_KEYFAMILY, new Object[0]);
                    }
                    if (this.keyFamilyId != null && !andType.getKeyFamilyList().get(0).equals(this.keyFamilyId)) {
                        throw new ValidationException("Multiple Data Structure Ids not supported on DataWhere - got '" + this.keyFamilyId + "' and '" + andType.getKeyFamilyList().get(0) + "'");
                    }
                    this.keyFamilyId = andType.getKeyFamilyList().get(0);
                }
                if (ObjectUtil.validCollection(andType.getDataflowList())) {
                    if (andType.getDataflowList().size() > 1) {
                        throw new UnsupportedException(new Object[]{"Multiple Dataflow Ids not supported in an AND operation"});
                    }
                    if (this.dataflowId != null && !andType.getDataflowList().get(0).equals(this.dataflowId)) {
                        throw new ValidationException("Multiple Dataflow Ids not supported on DataWhere - got '" + this.dataflowId + "' and '" + andType.getDataflowList().get(0) + "'");
                    }
                    this.dataflowId = andType.getDataflowList().get(0);
                }
                this.processOr(andType.getOrList(), selections);
                this.addGroupIfSelectionsExist(selections, dateFrom, dateTo);
            }
        }

        private void processAnd(List<AndType> andTypes) {
            if (andTypes != null) {
                for (AndType andType : andTypes) {
                    this.processAnd(andType);
                }
            }
        }

        private void processOr(List<OrType> orTypes, Set<DataQuerySelection> selections) {
            if (orTypes != null) {
                for (OrType orType : orTypes) {
                    this.processOr(orType, selections);
                }
            }
        }

        private void processOr(OrType orType, Set<DataQuerySelection> selections) {
            if (orType != null) {
                if (orType.getDimensionList() != null) {
                    for (DimensionType currentDimension : orType.getDimensionList()) {
                        this.addComponentSelection(selections, currentDimension.getId(), currentDimension.getStringValue());
                    }
                }
                if (orType.getAttributeList() != null) {
                    for (AttributeType currentAttribute : orType.getAttributeList()) {
                        this.addComponentSelection(selections, currentAttribute.getId(), currentAttribute.getStringValue());
                    }
                }
                if (ObjectUtil.validCollection(orType.getKeyFamilyList())) {
                    throw new UnsupportedException(new Object[]{"Key Family not supported in the DataQuery.OR, please put in DataQuery.AND"});
                }
                if (ObjectUtil.validCollection(orType.getDataflowList())) {
                    throw new UnsupportedException(new Object[]{"Dataflow not supported in the DataQuery.OR, please put in DataQuery.AND"});
                }
                this.processAnd(orType.getAndList());
            }
        }

        private void addComponentSelection(Set<DataQuerySelection> selections, String conceptId, String value) {
            for (DataQuerySelection selection : selections) {
                if (!selection.getComponentId().equals(conceptId)) continue;
                ((DataQueryDimensionSelectionImpl)selection).addValue(value);
                return;
            }
            DataQueryDimensionSelectionImpl newSelection = new DataQueryDimensionSelectionImpl(conceptId, value);
            selections.add(newSelection);
        }
    }

    private class Time {
        SdmxDate dateFrom = null;
        SdmxDate dateTo = null;

        private Time(TimeType timeType) {
            if (timeType.getTime() != null) {
                if (this.dateFrom != null) {
                    throw new ModelException(ExceptionCode.QUERY_SELECTION_MULTIPLE_DATE_FROM, new Object[0]);
                }
                if (this.dateTo != null) {
                    throw new ModelException(ExceptionCode.QUERY_SELECTION_MULTIPLE_DATE_TO, new Object[0]);
                }
                this.dateFrom = this.parseDate(timeType.getTime());
                this.dateTo = this.parseDate(timeType.getTime());
            }
            if (timeType.getStartTime() != null) {
                if (this.dateFrom != null) {
                    throw new ModelException(ExceptionCode.QUERY_SELECTION_MULTIPLE_DATE_FROM, new Object[0]);
                }
                this.dateFrom = this.parseDate(timeType.getStartTime());
            }
            if (timeType.getEndTime() != null) {
                if (this.dateTo != null) {
                    throw new ModelException(ExceptionCode.QUERY_SELECTION_MULTIPLE_DATE_TO, new Object[0]);
                }
                this.dateTo = this.parseDate(timeType.getEndTime());
            }
        }

        private SdmxDate parseDate(Object obj) {
            return new SdmxDateImpl(obj.toString());
        }
    }
}

