/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryProvisioningResponseType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusType;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ProvisionAgreementXmlBeanBuilder;
import org.sdmxsource.util.ObjectUtil;

public class QueryProvisionResponseBuilderV2
extends AbstractResponseBuilder {
    public static QueryProvisionResponseBuilderV2 INSTANCE = new QueryProvisionResponseBuilderV2();
    private ProvisionAgreementXmlBeanBuilder provBuilder = ProvisionAgreementXmlBeanBuilder.INSTANCE;

    private QueryProvisionResponseBuilderV2() {
    }

    public RegistryInterfaceDocument buildErrorResponse(Throwable th) {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryProvisioningResponseType returnType = regInterface.addNewQueryProvisioningResponse();
        V2Helper.setHeader(regInterface);
        StatusMessageType statusMessage = returnType.addNewStatusMessage();
        this.addStatus(statusMessage, th);
        return responseType;
    }

    public RegistryInterfaceDocument buildSuccessResponse(Collection<ProvisionAgreementBean> provisions) {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryProvisioningResponseType returnType = regInterface.addNewQueryProvisioningResponse();
        V2Helper.setHeader(regInterface);
        StatusMessageType statusMessage = returnType.addNewStatusMessage();
        this.addStatus(statusMessage, null);
        if (!ObjectUtil.validCollection(provisions)) {
            statusMessage.setStatus(StatusType.WARNING);
            TextType tt = statusMessage.addNewMessageText();
            tt.setStringValue("No Provisions Match The Query Parameters");
        } else {
            statusMessage.setStatus(StatusType.SUCCESS);
            ProvisionAgreementType[] provTypes = new ProvisionAgreementType[provisions.size()];
            int i = 0;
            for (ProvisionAgreementBean currentProv : provisions) {
                provTypes[i] = this.provBuilder.build(currentProv);
                ++i;
            }
            returnType.setProvisionAgreementArray(provTypes);
        }
        return responseType;
    }
}

