/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowRefType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategoryBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingCategoryBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="CategoryXmlBeanBuilderV2")
public class CategoryXmlBeanBuilder
extends AbstractBuilder {
    public CategoryType build(ReportingCategoryBean buildFrom) throws BuilderException {
        CategoryType builtObj = CategoryType.Factory.newInstance();
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (ObjectUtil.validCollection(buildFrom.getItems())) {
            for (ReportingCategoryBean currentReportingCategory : buildFrom.getItems()) {
                builtObj.getCategoryList().add(this.build(currentReportingCategory));
            }
        }
        return builtObj;
    }

    public CategoryType build(CategoryBean buildFrom, Set<CategorisationBean> categorisations) throws BuilderException {
        CategoryType builtObj = CategoryType.Factory.newInstance();
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (categorisations != null) {
            for (CategorisationBean cat : categorisations) {
                CrossReferenceBean catRef = cat.getCategoryReference();
                if (!catRef.isMatch(buildFrom)) continue;
                if (cat.getStructureReference().getTargetReference() == SDMX_STRUCTURE_TYPE.DATAFLOW) {
                    DataflowRefType dataflowRefType = builtObj.addNewDataflowRef();
                    MaintainableRefBean dfRef = cat.getStructureReference().getMaintainableReference();
                    if (this.validString(dfRef.getAgencyId())) {
                        dataflowRefType.setAgencyID(dfRef.getAgencyId());
                    }
                    if (this.validString(dfRef.getMaintainableId())) {
                        dataflowRefType.setDataflowID(dfRef.getMaintainableId());
                    }
                    if (this.validString(dfRef.getVersion())) {
                        dataflowRefType.setVersion(dfRef.getVersion());
                    }
                    if (!this.validString(cat.getStructureReference().getTargetUrn())) continue;
                    dataflowRefType.setURN(cat.getStructureReference().getTargetUrn());
                    continue;
                }
                if (cat.getStructureReference().getTargetReference() != SDMX_STRUCTURE_TYPE.METADATA_FLOW) continue;
                MetadataflowRefType metdataflowRefType = builtObj.addNewMetadataflowRef();
                MaintainableRefBean mdfRef = cat.getStructureReference().getMaintainableReference();
                if (this.validString(mdfRef.getAgencyId())) {
                    metdataflowRefType.setAgencyID(mdfRef.getAgencyId());
                }
                if (this.validString(mdfRef.getMaintainableId())) {
                    metdataflowRefType.setMetadataflowID(mdfRef.getMaintainableId());
                }
                if (this.validString(mdfRef.getVersion())) {
                    metdataflowRefType.setVersion(mdfRef.getVersion());
                }
                if (!this.validString(cat.getStructureReference().getTargetUrn())) continue;
                metdataflowRefType.setURN(cat.getStructureReference().getTargetUrn());
            }
        }
        if (ObjectUtil.validCollection(buildFrom.getItems())) {
            for (CategoryBean currentCategory : buildFrom.getItems()) {
                builtObj.getCategoryList().add(this.build(currentCategory, categorisations));
            }
        }
        return builtObj;
    }
}

