/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import org.sdmx.resources.sdmxml.schemas.v20.structure.AgenciesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataConsumersType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataProvidersType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeType;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.OrganisationRoleXmlBeanBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OrganisationSchemeXmlBeanBuilderV2")
public class OrganisationSchemeXmlBeanBuilder
extends AbstractBuilder {
    @Autowired
    private OrganisationRoleXmlBeanBuilder organisationRoleXmlBeanBuilder;

    public OrganisationSchemeType build(DataProviderSchemeBean dataProviderSchemeBean) throws BuilderException {
        OrganisationSchemeType builtObj = this.getOrganisationSchemeType(dataProviderSchemeBean);
        DataProvidersType type = builtObj.addNewDataProviders();
        for (DataProviderBean currentDc : dataProviderSchemeBean.getItems()) {
            type.getDataProviderList().add(this.organisationRoleXmlBeanBuilder.build(currentDc));
        }
        return builtObj;
    }

    public OrganisationSchemeType build(DataConsumerSchemeBean dataConsumerScheme) throws BuilderException {
        OrganisationSchemeType builtObj = this.getOrganisationSchemeType(dataConsumerScheme);
        DataConsumersType dcType = builtObj.addNewDataConsumers();
        for (DataConsumerBean currentDc : dataConsumerScheme.getItems()) {
            dcType.getDataConsumerList().add(this.organisationRoleXmlBeanBuilder.build(currentDc));
        }
        return builtObj;
    }

    public OrganisationSchemeType build(AgencySchemeBean agencySchemeBean) throws BuilderException {
        OrganisationSchemeType builtObj = this.getOrganisationSchemeType(agencySchemeBean);
        AgenciesType type = builtObj.addNewAgencies();
        for (AgencyBean currentBean : agencySchemeBean.getItems()) {
            type.getAgencyList().add(this.organisationRoleXmlBeanBuilder.build(currentBean));
        }
        return builtObj;
    }

    private OrganisationSchemeType getOrganisationSchemeType(MaintainableBean buildFrom) throws BuilderException {
        OrganisationSchemeType builtObj = OrganisationSchemeType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgencyID(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (buildFrom.getStartDate() != null) {
            builtObj.setValidFrom(buildFrom.getStartDate().getDate());
        }
        if (buildFrom.getEndDate() != null) {
            builtObj.setValidTo(buildFrom.getEndDate().getDate());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (buildFrom.isExternalReference().isSet()) {
            builtObj.setIsExternalReference(buildFrom.isExternalReference().isTrue());
        }
        if (buildFrom.isFinal().isSet()) {
            builtObj.setIsFinal(buildFrom.isFinal().isTrue());
        }
        return builtObj;
    }
}

