/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DistinctKeyType;
import org.sdmx.resources.sdmxml.schemas.v21.common.QueryableDataSourceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SetReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintAttachmentType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataKeySetType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstrainedDataKeyBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintAttachmentBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintDataKeySetBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.MaintainableBeanAssembler;

public class ConstraintBeanAssembler
extends MaintainableBeanAssembler
implements Assembler<ConstraintType, ConstraintBean> {
    @Override
    public void assemble(ConstraintType assembleInto, ConstraintBean assembleFrom) throws BuilderException {
        super.assembleMaintainable(assembleInto, assembleFrom);
        if (assembleFrom.getConstraintAttachment() != null) {
            this.buildConstraintAttachment(assembleInto.addNewConstraintAttachment(), assembleFrom.getConstraintAttachment());
        }
        DataKeySetType type = null;
        if (assembleFrom.getIncludedSeriesKeys() != null) {
            type = assembleInto.addNewDataKeySet();
            this.buildDataKeySet(type, assembleFrom.getIncludedSeriesKeys(), true);
        }
        if (assembleFrom.getExcludedSeriesKeys() != null) {
            if (type == null) {
                type = assembleInto.addNewDataKeySet();
            }
            this.buildDataKeySet(type, assembleFrom.getExcludedSeriesKeys(), true);
        }
    }

    private void buildDataKeySet(DataKeySetType type, ConstraintDataKeySetBean bean, boolean included) {
        type.setIsIncluded(included);
        for (ConstrainedDataKeyBean dkBean : bean.getConstrainedDataKeys()) {
            DistinctKeyType keyType = type.addNewKey();
            for (KeyValue kv : dkBean.getKeyValues()) {
                ComponentValueSetType cvType = keyType.addNewKeyValue();
                cvType.setId(kv.getConcept());
                cvType.addNewValue().setStringValue(kv.getCode());
            }
        }
    }

    private void buildConstraintAttachment(ConstraintAttachmentType type, ConstraintAttachmentBean bean) {
        if (bean.getDataOrMetadataSetReference() != null) {
            if (bean.getDataOrMetadataSetReference().isDataSetReference()) {
                SetReferenceType refType = type.addNewDataSet();
                refType.setID(bean.getDataOrMetadataSetReference().getSetId());
                super.setReference(refType.addNewDataProvider().addNewRef(), bean.getDataOrMetadataSetReference().getDataSetReference());
            } else {
                SetReferenceType mdsRefType = type.addNewMetadataSet();
                mdsRefType.setID(bean.getDataOrMetadataSetReference().getSetId());
                super.setReference(mdsRefType.addNewDataProvider().addNewRef(), bean.getDataOrMetadataSetReference().getDataSetReference());
            }
        }
        if (bean.getDataSources() != null) {
            for (DataSourceBean ds : bean.getDataSources()) {
                if (ds.isSimpleDatasource()) {
                    if (ds.getDataUrl() == null) continue;
                    type.addSimpleDataSource(ds.getDataUrl().toString());
                    continue;
                }
                QueryableDataSourceType dsType = type.addNewQueryableDataSource();
                if (ds.getDataUrl() != null) {
                    dsType.setDataURL(ds.getDataUrl().toString());
                }
                dsType.setIsRESTDatasource(ds.isRESTDatasource());
                dsType.setIsWebServiceDatasource(ds.isWebServiceDatasource());
                if (ds.getWadlUrl() != null) {
                    dsType.setWADLURL(ds.getWadlUrl().toString());
                }
                if (ds.getWSDLUrl() == null) continue;
                dsType.setWSDLURL(ds.getWSDLUrl().toString());
            }
        }
        CrossReferenceBean attachment = null;
        Enum attached = null;
        block17: for (CrossReferenceBean currentRef : bean.getStructureReference()) {
            switch (currentRef.getTargetReference()) {
                case DATA_PROVIDER: {
                    if (attached != null) break;
                    attached = currentRef.getTargetReference();
                    attachment = currentRef;
                    break;
                }
                case DSD: {
                    if (attached != null && attached != SDMX_STRUCTURE_TYPE.DATA_PROVIDER) continue block17;
                    attached = currentRef.getTargetReference();
                    attachment = currentRef;
                    break;
                }
                case MSD: {
                    break;
                }
                case DATAFLOW: {
                    if (attached != null && attached != SDMX_STRUCTURE_TYPE.DATA_PROVIDER && attached != SDMX_STRUCTURE_TYPE.DSD) continue block17;
                    attached = currentRef.getTargetReference();
                    attachment = currentRef;
                    break;
                }
                case METADATA_FLOW: {
                    if (attached != null && attached != SDMX_STRUCTURE_TYPE.DATA_PROVIDER) continue block17;
                    attached = currentRef.getTargetReference();
                    attachment = currentRef;
                    break;
                }
                case PROVISION_AGREEMENT: {
                    attached = currentRef.getTargetReference();
                    attachment = currentRef;
                }
            }
        }
        switch (ConstraintBeanAssembler.$SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$SDMX_STRUCTURE_TYPE()[attached.ordinal()]) {
            case 34: {
                super.setReference(type.addNewDataProvider().addNewRef(), attachment);
                break;
            }
            case 52: {
                super.setReference(type.addNewDataStructure().addNewRef(), attachment);
                break;
            }
            case 64: {
                super.setReference(type.addNewMetadataStructure().addNewRef(), attachment);
                break;
            }
            case 55: {
                super.setReference(type.addNewDataflow().addNewRef(), attachment);
                break;
            }
            case 68: {
                super.setReference(type.addNewMetadataflow().addNewRef(), attachment);
                break;
            }
            case 77: {
                super.setReference(type.addNewProvisionAgreement().addNewRef(), attachment);
            }
        }
    }
}

