/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ContactType;
import org.sdmx.resources.sdmxml.schemas.v21.message.PartyType;
import org.sdmx.resources.sdmxml.schemas.v21.message.SenderType;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureHeaderType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.AbstractBeanAssembler;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class StructureHeaderXmlBeanBuilder
extends AbstractBeanAssembler
implements Builder<StructureHeaderType, HeaderBean> {
    @Override
    public StructureHeaderType build(HeaderBean buildFrom) throws BuilderException {
        TextType tt;
        StructureHeaderType headerType = StructureHeaderType.Factory.newInstance();
        if (ObjectUtil.validString(buildFrom.getId())) {
            headerType.setID(buildFrom.getId());
        }
        headerType.setTest(buildFrom.isTest());
        if (buildFrom.getName() != null) {
            for (String locale : buildFrom.getName().keySet()) {
                tt = headerType.addNewName();
                tt.setLang(locale);
                tt.setStringValue(buildFrom.getName().get(locale));
            }
        }
        if (buildFrom.getSource() != null) {
            for (String locale : buildFrom.getSource().keySet()) {
                tt = headerType.addNewSource();
                tt.setLang(locale);
                tt.setStringValue(buildFrom.getSource().get(locale));
            }
        }
        if (buildFrom.getPrepared() != null) {
            headerType.setPrepared(DateUtil.createCalendar(buildFrom.getPrepared()));
        }
        if (buildFrom.getSender() != null) {
            PartyBean sender = buildFrom.getSender();
            SenderType senderType = headerType.addNewSender();
            if (ObjectUtil.validString(sender.getId())) {
                senderType.setId(sender.getId());
            }
            for (String locale : sender.getName().keySet()) {
                TextType tt2 = senderType.addNewName();
                tt2.setLang(locale);
                tt2.setStringValue(sender.getName().get(locale));
            }
            for (PartyBean.ContactBean contact : sender.getContacts()) {
                this.buildContact(senderType.addNewContact(), contact);
            }
        }
        if (buildFrom.getReceiver() != null) {
            for (PartyBean receiver : buildFrom.getReceiver()) {
                PartyType receiverType = headerType.addNewReceiver();
                if (ObjectUtil.validString(receiver.getId())) {
                    receiverType.setId(receiver.getId());
                }
                for (String locale : receiver.getName().keySet()) {
                    TextType tt3 = receiverType.addNewName();
                    tt3.setLang(locale);
                    tt3.setStringValue(receiver.getName().get(locale));
                }
                for (PartyBean.ContactBean contact : receiver.getContacts()) {
                    this.buildContact(receiverType.addNewContact(), contact);
                }
            }
        }
        if (!ObjectUtil.validCollection(headerType.getReceiverList())) {
            PartyType receiverType = headerType.addNewReceiver();
            receiverType.setId("unknown");
        }
        return headerType;
    }

    private void buildContact(ContactType contactType, PartyBean.ContactBean contact) {
        TextType tt;
        if (contact.getDepartments() != null) {
            for (String locale : contact.getDepartments().keySet()) {
                tt = contactType.addNewDepartment();
                tt.setLang(locale);
                tt.setStringValue(contact.getDepartments().get(locale));
            }
        }
        if (contact.getName() != null) {
            for (String locale : contact.getName().keySet()) {
                tt = contactType.addNewName();
                tt.setLang(locale);
                tt.setStringValue(contact.getName().get(locale));
            }
        }
        if (contact.getRole() != null) {
            for (String locale : contact.getRole().keySet()) {
                tt = contactType.addNewRole();
                tt.setLang(locale);
                tt.setStringValue(contact.getRole().get(locale));
            }
        }
        if (contact.getEmail() != null) {
            for (String val : contact.getEmail()) {
                contactType.addEmail(val);
            }
        }
        if (contact.getFax() != null) {
            for (String val : contact.getFax()) {
                contactType.addFax(val);
            }
        }
        if (contact.getTelephone() != null) {
            for (String val : contact.getTelephone()) {
                contactType.addTelephone(val);
            }
        }
        if (contact.getUri() != null) {
            for (String val : contact.getUri()) {
                contactType.addURI(val);
            }
        }
        if (contact.getX400() != null) {
            for (String val : contact.getX400()) {
                contactType.addX400(val);
            }
        }
    }
}

