/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.sdmx.resources.sdmxml.schemas.v21.common.AgencyRefType;
import org.sdmx.resources.sdmxml.schemas.v21.common.CategoryReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataConsumerRefType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataProviderRefType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataProviderReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.OrganisationReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.OrganisationUnitRefType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ProvisionAgreementReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.DataRegistrationEventsType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.EventSelectorType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.IdentifiableObjectEventType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.MaintainableEventType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.MaintainableQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.MetadataRegistrationEventsType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.NotificationURLType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.StructuralRepositoryEventsType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubscriptionType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.ValidityPeriodType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.VersionableObjectEventType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.NameableBeanAssembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionXmlBeanBuilder
extends NameableBeanAssembler
implements Builder<SubscriptionType, SubscriptionBean> {
    @Override
    public SubscriptionType build(SubscriptionBean buildFrom) throws BuilderException {
        NotificationURLType notificationUrl;
        SubscriptionType subscriptionType = SubscriptionType.Factory.newInstance();
        OrganisationReferenceType orfRef = subscriptionType.addNewOrganisation();
        RefBaseType ref = orfRef.addNewRef();
        super.setReference(ref, buildFrom.getOwner());
        XmlCursor cursor = ref.newCursor();
        cursor.insertNamespace("com", AgencyRefType.type.getName().getNamespaceURI());
        switch (buildFrom.getOwner().getTargetReference()) {
            case AGENCY: {
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), "com:" + AgencyRefType.type.getName().getLocalPart());
                break;
            }
            case DATA_PROVIDER: {
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), "com:" + DataProviderRefType.type.getName().getLocalPart());
                break;
            }
            case DATA_CONSUMER: {
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), "com:" + DataConsumerRefType.type.getName().getLocalPart());
                break;
            }
            case ORGANISATION_UNIT: {
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), "com:" + OrganisationUnitRefType.type.getName().getLocalPart());
            }
        }
        for (String currentHttp : buildFrom.getHTTPPostTo()) {
            notificationUrl = subscriptionType.addNewNotificationHTTP();
            notificationUrl.setStringValue(currentHttp);
        }
        for (String currentHttp : buildFrom.getMailTo()) {
            notificationUrl = subscriptionType.addNewNotificationMailTo();
            notificationUrl.setStringValue(currentHttp);
        }
        subscriptionType.setSubscriberAssignedID(buildFrom.getId());
        ValidityPeriodType validityPeriod = subscriptionType.addNewValidityPeriod();
        if (buildFrom.getStartDate() != null) {
            validityPeriod.setStartDate(buildFrom.getStartDate().getDateAsCalendar());
        }
        if (buildFrom.getEndDate() != null) {
            validityPeriod.setEndDate(buildFrom.getEndDate().getDateAsCalendar());
        }
        EventSelectorType eventSelector = subscriptionType.addNewEventSelector();
        List<StructureReferenceBean> structureReferences = buildFrom.getReferences();
        switch (buildFrom.getSubscriptionType()) {
            case DATA_REGISTRATION: {
                this.buildDataSubscription(eventSelector, structureReferences);
                break;
            }
            case METADATA_REGISTRATION: {
                this.buildMetadataSubscription(eventSelector, structureReferences);
                break;
            }
            case STRUCTURE: {
                this.buildStructureSubscription(eventSelector, structureReferences);
            }
        }
        return subscriptionType;
    }

    private void buildStructureSubscription(EventSelectorType eventSelector, List<StructureReferenceBean> subscriptions) {
        MaintainableRefBean mRef;
        StructuralRepositoryEventsType structureEvents = eventSelector.addNewStructuralRepositoryEvents();
        boolean addedAgency = false;
        for (StructureReferenceBean sRef : subscriptions) {
            mRef = sRef.getMaintainableReference();
            if (!ObjectUtil.validString(mRef.getAgencyId())) continue;
            structureEvents.addAgencyID(mRef.getAgencyId());
            addedAgency = true;
        }
        if (!addedAgency) {
            structureEvents.addAgencyID("%");
        }
        for (StructureReferenceBean sRef : subscriptions) {
            mRef = sRef.getMaintainableReference();
            switch (sRef.getTargetReference()) {
                case ANY: {
                    structureEvents.addNewAllEvents();
                    break;
                }
                case AGENCY_SCHEME: {
                    this.setVersionObjectEventInfo(structureEvents.addNewAgencyScheme(), mRef);
                    break;
                }
                case ATTACHMENT_CONSTRAINT: {
                    this.setVersionObjectEventInfo(structureEvents.addNewAttachmentConstraint(), mRef);
                    break;
                }
                case CATEGORY_SCHEME: {
                    this.setVersionObjectEventInfo(structureEvents.addNewCategoryScheme(), mRef);
                    break;
                }
                case CODE_LIST: {
                    this.setVersionObjectEventInfo(structureEvents.addNewCodelist(), mRef);
                    break;
                }
                case CONCEPT_SCHEME: {
                    this.setVersionObjectEventInfo(structureEvents.addNewConceptScheme(), mRef);
                    break;
                }
                case CONTENT_CONSTRAINT: {
                    this.setVersionObjectEventInfo(structureEvents.addNewContentConstraint(), mRef);
                    break;
                }
                case DATA_CONSUMER_SCHEME: {
                    this.setVersionObjectEventInfo(structureEvents.addNewDataConsmerScheme(), mRef);
                    break;
                }
                case DATAFLOW: {
                    this.setVersionObjectEventInfo(structureEvents.addNewDataflow(), mRef);
                    break;
                }
                case DATA_PROVIDER_SCHEME: {
                    this.setVersionObjectEventInfo(structureEvents.addNewDataProviderScheme(), mRef);
                    break;
                }
                case HIERARCHICAL_CODELIST: {
                    this.setVersionObjectEventInfo(structureEvents.addNewHierarchicalCodelist(), mRef);
                    break;
                }
                case DSD: {
                    this.setVersionObjectEventInfo(structureEvents.addNewKeyFamily(), mRef);
                    break;
                }
                case METADATA_FLOW: {
                    this.setVersionObjectEventInfo(structureEvents.addNewMetadataflow(), mRef);
                    break;
                }
                case MSD: {
                    this.setVersionObjectEventInfo(structureEvents.addNewMetadataStructureDefinition(), mRef);
                    break;
                }
                case ORGANISATION_UNIT_SCHEME: {
                    this.setVersionObjectEventInfo(structureEvents.addNewOrganisationUnitScheme(), mRef);
                    break;
                }
                case PROCESS: {
                    this.setVersionObjectEventInfo(structureEvents.addNewProcess(), mRef);
                    break;
                }
                case PROVISION_AGREEMENT: {
                    this.setVersionObjectEventInfo(structureEvents.addNewProvisionAgreement(), mRef);
                    break;
                }
                case REPORTING_TAXONOMY: {
                    this.setVersionObjectEventInfo(structureEvents.addNewReportingTaxonomy(), mRef);
                    break;
                }
                case STRUCTURE_SET: {
                    this.setVersionObjectEventInfo(structureEvents.addNewStructureSet(), mRef);
                    break;
                }
                case CATEGORISATION: {
                    this.setIdentifiableObjectEventInfo(structureEvents.addNewCategorisation(), mRef);
                }
            }
        }
    }

    private void setVersionObjectEventInfo(VersionableObjectEventType vob, MaintainableRefBean ref) {
        if (ObjectUtil.validOneString(ref.getMaintainableId(), ref.getVersion())) {
            if (ObjectUtil.validString(ref.getMaintainableId())) {
                vob.setID(ref.getMaintainableId());
            } else {
                vob.setID("%");
            }
            if (ObjectUtil.validString(ref.getVersion())) {
                vob.setVersion(ref.getVersion());
            } else {
                vob.setVersion("%");
            }
        } else {
            vob.addNewAll();
        }
    }

    private void setIdentifiableObjectEventInfo(IdentifiableObjectEventType vob, MaintainableRefBean ref) {
        if (ObjectUtil.validString(ref.getMaintainableId())) {
            vob.setID(ref.getMaintainableId());
        } else {
            vob.addNewAll();
        }
    }

    private void buildDataSubscription(EventSelectorType eventSelector, List<StructureReferenceBean> subscriptions) {
        DataRegistrationEventsType dataRegistrationEventsType = eventSelector.addNewDataRegistrationEvents();
        for (StructureReferenceBean sRef : subscriptions) {
            MaintainableRefBean mRef = sRef.getMaintainableReference();
            switch (sRef.getTargetReference()) {
                case ANY: {
                    dataRegistrationEventsType.addNewAllEvents();
                    break;
                }
                case CATEGORY: {
                    CategoryReferenceType catRef = dataRegistrationEventsType.addNewCategory();
                    super.setReference(catRef.addNewRef(), sRef);
                    break;
                }
                case PROVISION_AGREEMENT: {
                    ProvisionAgreementReferenceType provisionRef = dataRegistrationEventsType.addNewProvisionAgreement();
                    super.setReference(provisionRef.addNewRef(), sRef);
                    break;
                }
                case DATA_PROVIDER: {
                    DataProviderReferenceType providerRef = dataRegistrationEventsType.addNewDataProvider();
                    super.setReference(providerRef.addNewRef(), sRef);
                }
                case DATAFLOW: {
                    this.setMaintainableEventInfo(dataRegistrationEventsType.addNewDataflowReference(), mRef);
                }
                case DSD: {
                    this.setMaintainableEventInfo(dataRegistrationEventsType.addNewKeyFamilyReference(), mRef);
                }
            }
        }
    }

    private void setMaintainableEventInfo(MaintainableEventType maintEventType, MaintainableRefBean ref) {
        MaintainableQueryType maintQueryType = maintEventType.addNewRef();
        if (ObjectUtil.validString(ref.getAgencyId())) {
            maintQueryType.setAgencyID(ref.getAgencyId());
        }
        if (ObjectUtil.validString(ref.getMaintainableId())) {
            maintQueryType.setId(ref.getMaintainableId());
        }
        if (ObjectUtil.validString(ref.getVersion())) {
            maintQueryType.setVersion(ref.getVersion());
        }
    }

    private void buildMetadataSubscription(EventSelectorType eventSelector, List<StructureReferenceBean> subscriptions) {
        MetadataRegistrationEventsType metadatadataRegistrationEventsType = eventSelector.addNewMetadataRegistrationEvents();
        for (StructureReferenceBean sRef : subscriptions) {
            MaintainableRefBean mRef = sRef.getMaintainableReference();
            switch (sRef.getTargetReference()) {
                case ANY: {
                    metadatadataRegistrationEventsType.addNewAllEvents();
                    break;
                }
                case CATEGORY: {
                    CategoryReferenceType catRef = metadatadataRegistrationEventsType.addNewCategory();
                    super.setReference(catRef.addNewRef(), sRef);
                    break;
                }
                case PROVISION_AGREEMENT: {
                    ProvisionAgreementReferenceType provisionRef = metadatadataRegistrationEventsType.addNewProvisionAgreement();
                    super.setReference(provisionRef.addNewRef(), sRef);
                    break;
                }
                case DATA_PROVIDER: {
                    DataProviderReferenceType providerRef = metadatadataRegistrationEventsType.addNewDataProvider();
                    super.setReference(providerRef.addNewRef(), sRef);
                }
                case METADATA_FLOW: {
                    this.setMaintainableEventInfo(metadatadataRegistrationEventsType.addNewMetadataflowReference(), mRef);
                }
                case MSD: {
                    this.setMaintainableEventInfo(metadatadataRegistrationEventsType.addNewMetadataStructureDefinitionReference(), mRef);
                }
            }
        }
    }
}

