/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import java.util.Collection;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.AnnotationType;
import org.sdmx.resources.sdmxml.schemas.v21.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ObjectTypeCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.common.PackageTypeCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.reference.IdentifiableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.util.ObjectUtil;

public class AbstractBeanAssembler {
    protected boolean validString(String string) {
        return ObjectUtil.validString(string);
    }

    protected boolean validCollection(Collection collection) {
        return ObjectUtil.validCollection(collection);
    }

    TextType[] getTextType(List<TextTypeWrapper> ttWrapper) {
        if (!ObjectUtil.validCollection(ttWrapper)) {
            return null;
        }
        TextType[] ttArr = new TextType[ttWrapper.size()];
        int i = 0;
        while (i < ttWrapper.size()) {
            TextType tt;
            ttArr[i] = tt = this.getTextType(ttWrapper.get(i));
            ++i;
        }
        return ttArr;
    }

    TextType getTextType(TextTypeWrapper ttWrapper) {
        TextType tt = TextType.Factory.newInstance();
        tt.setLang(ttWrapper.getLocale());
        tt.setStringValue(ttWrapper.getValue());
        return tt;
    }

    TextType getTextType(String englishString) {
        TextType tt = TextType.Factory.newInstance();
        tt.setLang("en");
        tt.setStringValue(englishString);
        return tt;
    }

    boolean hasAnnotations(AnnotableBean annotable) {
        return ObjectUtil.validCollection(annotable.getAnnotations());
    }

    protected void setReference(RefBaseType ref, StructureReferenceBean crossReference) {
        if (crossReference == null) {
            throw new IllegalArgumentException("Could not set reference on artefact, no reference supplied");
        }
        MaintainableRefBean maintRef = crossReference.getMaintainableReference();
        if (crossReference.hasChildReference()) {
            String fullId = this.getFullIdentifiableId(crossReference);
            if (fullId.contains("\\.")) {
                String containerId = fullId.substring(0, fullId.lastIndexOf("\\."));
                String targetId = fullId.substring(fullId.indexOf("\\."), fullId.length());
                ref.setContainerID(containerId);
                ref.setId(targetId);
            } else {
                ref.setId(fullId);
            }
            if (ObjectUtil.validString(maintRef.getMaintainableId())) {
                ref.setMaintainableParentID(maintRef.getMaintainableId());
            }
            if (ObjectUtil.validString(maintRef.getVersion())) {
                ref.setMaintainableParentVersion(maintRef.getVersion());
            }
        } else {
            if (ObjectUtil.validString(maintRef.getMaintainableId())) {
                ref.setId(maintRef.getMaintainableId());
            }
            if (ObjectUtil.validString(maintRef.getVersion())) {
                ref.setVersion(maintRef.getVersion());
            }
        }
        if (ObjectUtil.validString(maintRef.getAgencyId())) {
            ref.setAgencyID(maintRef.getAgencyId());
        }
        ref.setPackage(PackageTypeCodelistType.Enum.forString(crossReference.getTargetReference().getUrnPackage()));
        String urnClass = crossReference.getTargetReference().getUrnClass();
        ObjectTypeCodelistType.Enum classEnum = ObjectTypeCodelistType.Enum.forString(urnClass);
        if (classEnum == null) {
            throw new ValidationException("Unknown urnClass : " + (Object)((Object)classEnum));
        }
        ref.setClass1(classEnum);
    }

    private String getFullIdentifiableId(StructureReferenceBean crossReference) {
        String returnString = "";
        IdentifiableRefBean childReference = crossReference.getChildReference();
        String concat = "";
        while (childReference != null) {
            returnString = String.valueOf(returnString) + concat + childReference.getId();
            concat = ".";
            childReference = childReference.getChildReference();
        }
        return returnString;
    }

    AnnotationsType getAnnotationsType(AnnotableBean annotable) {
        if (!ObjectUtil.validCollection(annotable.getAnnotations())) {
            return null;
        }
        AnnotationsType returnType = AnnotationsType.Factory.newInstance();
        for (AnnotationBean currentAnnotationBean : annotable.getAnnotations()) {
            AnnotationType annotation = returnType.addNewAnnotation();
            if (ObjectUtil.validString(currentAnnotationBean.getId())) {
                annotation.setId(currentAnnotationBean.getId());
            }
            if (ObjectUtil.validCollection(currentAnnotationBean.getText())) {
                annotation.setAnnotationTextArray(this.getTextType(currentAnnotationBean.getText()));
            }
            if (ObjectUtil.validString(currentAnnotationBean.getTitle())) {
                annotation.setAnnotationTitle(currentAnnotationBean.getTitle());
            }
            if (ObjectUtil.validString(currentAnnotationBean.getType())) {
                annotation.setAnnotationType(currentAnnotationBean.getType());
            }
            if (currentAnnotationBean.getURL() == null) continue;
            annotation.setAnnotationURL(currentAnnotationBean.getURL().toString());
        }
        return returnType;
    }
}

