/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.reference;

import java.util.ArrayList;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.IdentifiableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CrossReferenceBeanImpl
extends StructureReferenceBeanImpl
implements CrossReferenceBean {
    private static final long serialVersionUID = -1103372297741893400L;
    private SDMXBean referencedFrom;

    public CrossReferenceBeanImpl(SDMXBean referencedFrom, StructureReferenceBean sRefBean) {
        super(sRefBean.getMaintainableReference().getAgencyId(), sRefBean.getMaintainableReference().getMaintainableId(), sRefBean.getMaintainableReference().getVersion(), sRefBean.getTargetReference(), sRefBean.getIdentifiableIds());
        this.referencedFrom = referencedFrom;
        this.validateReference();
    }

    public CrossReferenceBeanImpl(SDMXBean referencedFrom, String agencyId, String maintainableId, String version, SDMX_STRUCTURE_TYPE structureType) {
        super(agencyId, maintainableId, version, structureType, new String[0]);
        this.referencedFrom = referencedFrom;
        this.validateReference();
    }

    public static String[] getIdentifiableIds(IdentifiableRefBean ref) {
        if (ref == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        while (ref.getChildReference() != null) {
            ids.add(ref.getChildReference().getId());
        }
        String[] returnArray = new String[ids.size()];
        ids.toArray(returnArray);
        return returnArray;
    }

    public CrossReferenceBeanImpl(SDMXBean referencedFrom, String agencyId, String maintainableId, String version, SDMX_STRUCTURE_TYPE structureType, String ... identifiableIds) {
        super(agencyId, maintainableId, version, structureType, identifiableIds);
        this.referencedFrom = referencedFrom;
        this.validateReference();
    }

    public CrossReferenceBeanImpl(SDMXBean referencedFrom, String urn) {
        super(urn);
        this.referencedFrom = referencedFrom;
        this.validateReference();
    }

    @Override
    public SDMXBean getReferencedFrom() {
        return this.referencedFrom;
    }

    @Override
    public void setAgencyId(String agencyId) {
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "CrossReferenceBeanImpl.setAgencyId - CrossReferenceBeanImpl is immutbale");
    }

    @Override
    public void setVersion(String version) {
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "CrossReferenceBeanImpl.setVersion - CrossReferenceBeanImpl is immutbale");
    }

    @Override
    public void setChildReference(IdentifiableRefBean childReference) {
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "CrossReferenceBeanImpl.setChildReference - CrossReferenceBeanImpl is immutbale");
    }

    @Override
    public void setTargetStructureType(SDMX_STRUCTURE_TYPE targetStructureType) {
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "CrossReferenceBeanImpl.setTargetStructureType - CrossReferenceBeanImpl is immutbale");
    }

    @Override
    public void setMaintainableStructureType(SDMX_STRUCTURE_TYPE structureType) {
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "CrossReferenceBeanImpl.setMaintainableStructureType - CrossReferenceBeanImpl is immutbale");
    }

    @Override
    public void setMaintainableId(String maintainableId) {
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "CrossReferenceBeanImpl.setMaintainableId - CrossReferenceBeanImpl is immutbale");
    }

    @Override
    public StructureReferenceBean createMutableInstance() {
        return new StructureReferenceBeanImpl(this.getTargetUrn());
    }

    @Override
    public boolean isMatch(IdentifiableBean identifiableBean) {
        if (identifiableBean.getStructureType() == this.getTargetReference()) {
            return this.getTargetUrn().equals(identifiableBean.getUrn());
        }
        return false;
    }

    private void validateReference() {
        if (this.referencedFrom == null) {
            throw new StructureException(ExceptionCode.BEAN_MISSING_REQUIRED_ELEMENT, "referencedFrom");
        }
        if (!ObjectUtil.validString(this.getMaintainableReference().getAgencyId())) {
            throw new StructureException(ExceptionCode.BEAN_INCOMPLETE_REFERENCE, "Agency Id");
        }
        if (!ObjectUtil.validString(this.getMaintainableReference().getMaintainableId())) {
            throw new StructureException(ExceptionCode.BEAN_INCOMPLETE_REFERENCE, "Maintainable Id");
        }
        if (!ObjectUtil.validString(this.getMaintainableReference().getVersion())) {
            this.version = "1.0";
        }
        if (!this.getTargetReference().isMaintainable() && this.getChildReference() == null) {
            throw new ValidationException("Reference to " + this.getTargetReference().getType() + " missing identifiable parameters");
        }
    }

    @Override
    public String toString() {
        return "Cross Reference : " + this.getTargetUrn();
    }
}

