/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

public enum SDMX_SCHEMA {
    VERSION_ONE(true),
    VERSION_TWO(true),
    VERSION_TWO_POINT_ONE(true),
    EDI(false),
    ECV(false),
    CSV(false),
    JSON(false);

    private boolean xmlFormat;

    private SDMX_SCHEMA(boolean xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public boolean isXmlFormat() {
        return this.xmlFormat;
    }

    public String toString() {
        switch (this) {
            case VERSION_ONE: {
                return "1.0";
            }
            case VERSION_TWO: {
                return "2.0";
            }
            case VERSION_TWO_POINT_ONE: {
                return "2.1";
            }
            case CSV: {
                return "CSV";
            }
            case ECV: {
                return "ECV";
            }
            case EDI: {
                return "SDMX-EDI";
            }
            case JSON: {
                return "JSON";
            }
        }
        return super.toString();
    }

    public String toEnglishString() {
        switch (this) {
            case VERSION_ONE: 
            case VERSION_TWO: 
            case VERSION_TWO_POINT_ONE: {
                return "SDMX " + this.toString();
            }
            case CSV: 
            case ECV: 
            case EDI: 
            case JSON: {
                return this.toString();
            }
        }
        return this.toString();
    }
}

