/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.constants;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.ediparser.util.EDIDateUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;

public enum EDI_TIME_FORMAT {
    DAILY_TWO_DIG_YEAR("101", TIME_FORMAT.DATE, false),
    DAILY_FOUR_DIG_YEAR("102", TIME_FORMAT.DATE, false),
    MINUTE_TWO_DIG_YEAR("201", TIME_FORMAT.DATE_TIME, false),
    MINUTE_FOUR_DIG_YEAR("203", TIME_FORMAT.DATE_TIME, false),
    YEAR("602", TIME_FORMAT.YEAR, false),
    HALF_OF_YEAR("604", TIME_FORMAT.HALF_OF_YEAR, false),
    QUARTER_OF_YEAR("608", TIME_FORMAT.QUARTER_OF_YEAR, false),
    MONTH("610", TIME_FORMAT.MONTH, false),
    WEEK("616", TIME_FORMAT.WEEK, false),
    RANGE_YEAR("702", TIME_FORMAT.YEAR, true),
    RANGE_HALF_OF_YEAR("704", TIME_FORMAT.HALF_OF_YEAR, true),
    RANGE_QUARTER_OF_YEAR("708", TIME_FORMAT.QUARTER_OF_YEAR, true),
    RANGE_MONTHLY("710", TIME_FORMAT.MONTH, true),
    RANGE_DAILY("711", TIME_FORMAT.DATE, true),
    RANGE_WEEKLY("716", TIME_FORMAT.WEEK, true);

    private String ediValue;
    private TIME_FORMAT sdmxTimeFormat;
    private boolean isRange;
    private int expectedLength;

    private EDI_TIME_FORMAT(String ediValue, TIME_FORMAT timeFormat, boolean isRange) {
        this.ediValue = ediValue;
        this.sdmxTimeFormat = timeFormat;
        this.isRange = isRange;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public TIME_FORMAT getSdmxTimeFormat() {
        return this.sdmxTimeFormat;
    }

    public String getEdiValue() {
        return this.ediValue;
    }

    public static EDI_TIME_FORMAT parseTimeFormat(TIME_FORMAT timeFormat, boolean isRange) {
        switch (timeFormat) {
            case DATE: {
                return isRange ? RANGE_DAILY : DAILY_FOUR_DIG_YEAR;
            }
            case DATE_TIME: {
                return isRange ? RANGE_DAILY : MINUTE_FOUR_DIG_YEAR;
            }
            case HALF_OF_YEAR: {
                return isRange ? RANGE_HALF_OF_YEAR : HALF_OF_YEAR;
            }
            case HOUR: {
                return isRange ? RANGE_DAILY : MINUTE_FOUR_DIG_YEAR;
            }
            case MONTH: {
                return isRange ? RANGE_MONTHLY : MONTH;
            }
            case QUARTER_OF_YEAR: {
                return isRange ? RANGE_QUARTER_OF_YEAR : QUARTER_OF_YEAR;
            }
            case WEEK: {
                return isRange ? RANGE_WEEKLY : WEEK;
            }
            case YEAR: {
                return isRange ? RANGE_YEAR : YEAR;
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Output EDI time format of: " + (Object)((Object)timeFormat));
    }

    public Date parseDate(String dateString) {
        try {
            if (this.isRange) {
                return this.parseRange(dateString, 0);
            }
            return this.parseDate(dateString, this);
        }
        catch (ParseException parseException) {
            throw new ValidationException("Could not format date of type '" + (Object)((Object)this) + "' with date string '" + dateString + "'");
        }
    }

    public String formatDate(Date date) {
        EDI_TIME_FORMAT timeFormat = this;
        switch (this) {
            case RANGE_DAILY: {
                timeFormat = DAILY_FOUR_DIG_YEAR;
                break;
            }
            case RANGE_MONTHLY: {
                timeFormat = MONTH;
                break;
            }
            case RANGE_HALF_OF_YEAR: {
                timeFormat = HALF_OF_YEAR;
                break;
            }
            case RANGE_QUARTER_OF_YEAR: {
                timeFormat = QUARTER_OF_YEAR;
                break;
            }
            case RANGE_WEEKLY: {
                timeFormat = WEEK;
                break;
            }
            case RANGE_YEAR: {
                timeFormat = YEAR;
            }
        }
        switch (timeFormat) {
            case DAILY_FOUR_DIG_YEAR: {
                return EDIDateUtil.DATE_FORMAT_DAILY_LONG_YEAR.format(date);
            }
            case DAILY_TWO_DIG_YEAR: {
                return EDIDateUtil.DATE_FORMAT_DAILY_SHORT_YEAR.format(date);
            }
            case HALF_OF_YEAR: {
                String formatted = EDIDateUtil.DATE_FORMAT_YEARLY.format(date);
                Calendar cal = DateUtil.getCalendar();
                cal.setTime(date);
                formatted = cal.get(2) <= 6 ? String.valueOf(formatted) + "1" : String.valueOf(formatted) + "2";
                return formatted;
            }
            case MINUTE_FOUR_DIG_YEAR: {
                return EDIDateUtil.DATE_FORMAT_MINUTE_LONG_YEAR.format(date);
            }
            case MINUTE_TWO_DIG_YEAR: {
                return EDIDateUtil.DATE_FORMAT_MINUTE_SHORT_YEAR.format(date);
            }
            case MONTH: {
                return EDIDateUtil.DATE_FORMAT_MONTHLY.format(date);
            }
            case WEEK: {
                LocalDate dateTimeFrom = new LocalDate((Object)date, DateTimeZone.UTC);
                int weekNum = dateTimeFrom.getWeekOfWeekyear();
                int year = dateTimeFrom.getWeekyear();
                if (weekNum < 10) {
                    return String.valueOf(year) + "0" + weekNum;
                }
                return String.valueOf(year) + weekNum;
            }
            case YEAR: {
                return EDIDateUtil.DATE_FORMAT_YEARLY.format(date);
            }
            case QUARTER_OF_YEAR: {
                String formatted = EDIDateUtil.DATE_FORMAT_YEARLY.format(date);
                Calendar cal = DateUtil.getCalendar();
                cal.setTime(date);
                formatted = cal.get(2) <= 2 ? String.valueOf(formatted) + "1" : (cal.get(2) <= 5 ? String.valueOf(formatted) + "2" : (cal.get(2) <= 8 ? String.valueOf(formatted) + "3" : String.valueOf(formatted) + "4"));
                return formatted;
            }
        }
        throw new UnsupportedException(new Object[]{"EDI date format : " + (Object)((Object)this)});
    }

    private Date parseDate(String ediDateString, EDI_TIME_FORMAT timeFormat) throws ParseException {
        try {
            switch (timeFormat) {
                case DAILY_FOUR_DIG_YEAR: {
                    return EDIDateUtil.DATE_FORMAT_DAILY_LONG_YEAR.parse(ediDateString);
                }
                case DAILY_TWO_DIG_YEAR: {
                    return EDIDateUtil.DATE_FORMAT_DAILY_SHORT_YEAR.parse(ediDateString);
                }
                case HALF_OF_YEAR: {
                    return this.parseHalfYear(ediDateString);
                }
                case MINUTE_FOUR_DIG_YEAR: {
                    return EDIDateUtil.DATE_FORMAT_MINUTE_LONG_YEAR.parse(ediDateString);
                }
                case MINUTE_TWO_DIG_YEAR: {
                    return EDIDateUtil.DATE_FORMAT_MINUTE_SHORT_YEAR.parse(ediDateString);
                }
                case MONTH: {
                    return EDIDateUtil.DATE_FORMAT_MONTHLY.parse(ediDateString);
                }
                case WEEK: {
                    return EDIDateUtil.DATE_FORMAT_WEEKLY.parse(ediDateString);
                }
                case YEAR: {
                    return EDIDateUtil.DATE_FORMAT_YEARLY.parse(ediDateString);
                }
                case QUARTER_OF_YEAR: {
                    return this.parseQuaterYear(ediDateString);
                }
            }
            throw new UnsupportedException(new Object[]{"EDI date format : " + (Object)((Object)this)});
        }
        catch (ParseException parseException) {
            if (timeFormat.isRange) {
                throw new ValidationException("Could not parse date '" + ediDateString + "' edi time format '" + timeFormat.getEdiValue() + "' relates to " + timeFormat.getSdmxTimeFormat().getReadableCode() + " data, and is a range, and is therefore expected to provide a date with '" + timeFormat.getExpectedLength() + "' characters  ");
            }
            throw new ValidationException("Could not parse date '" + ediDateString + "' edi time format '" + timeFormat.getEdiValue() + "' relates to " + timeFormat.getSdmxTimeFormat().getReadableCode() + " data is expected to provide a date with '" + timeFormat.getExpectedLength() + "' characters ");
        }
    }

    private Date parseRange(String dateString, int range) throws ParseException {
        EDI_TIME_FORMAT tf;
        int dateLength;
        switch (this) {
            case RANGE_DAILY: {
                dateLength = 8;
                tf = DAILY_FOUR_DIG_YEAR;
                break;
            }
            case RANGE_HALF_OF_YEAR: {
                dateLength = 5;
                tf = HALF_OF_YEAR;
                break;
            }
            case RANGE_MONTHLY: {
                dateLength = 6;
                tf = MONTH;
                break;
            }
            case RANGE_QUARTER_OF_YEAR: {
                dateLength = 5;
                tf = QUARTER_OF_YEAR;
                break;
            }
            case RANGE_WEEKLY: {
                dateLength = 6;
                tf = WEEK;
                break;
            }
            case RANGE_YEAR: {
                dateLength = 4;
                tf = YEAR;
                break;
            }
            default: {
                throw new UnsupportedException(new Object[]{"EDI date format : " + (Object)((Object)this)});
            }
        }
        int startIdx = range * dateLength;
        int endIdx = range * dateLength + dateLength;
        try {
            String split = dateString.substring(startIdx, endIdx);
            return this.parseDate(split, tf);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String errorMessage = "Time Period not consistent with time format code. Time period '" + dateString + "'. Time format code '" + (Object)((Object)this) + "'";
            throw new ValidationException(errorMessage);
        }
    }

    private Date parseHalfYear(String dateString) throws ParseException {
        String yearHalf = dateString.substring(4);
        String year = dateString.substring(0, 4);
        int half = Integer.parseInt(yearHalf);
        switch (half) {
            case 1: {
                year = String.valueOf(year) + "0630";
                break;
            }
            case 2: {
                year = String.valueOf(year) + "1231";
            }
        }
        return EDIDateUtil.DATE_FORMAT_DAILY_LONG_YEAR.parse(year);
    }

    private Date parseQuaterYear(String dateString) throws ParseException {
        String yearQuater = dateString.substring(4);
        String year = dateString.substring(0, 4);
        int quarter = Integer.parseInt(yearQuater);
        switch (quarter) {
            case 1: {
                year = String.valueOf(year) + "0331";
                break;
            }
            case 2: {
                year = String.valueOf(year) + "0630";
                break;
            }
            case 3: {
                year = String.valueOf(year) + "0930";
                break;
            }
            case 4: {
                year = String.valueOf(year) + "1231";
            }
        }
        return EDIDateUtil.DATE_FORMAT_DAILY_LONG_YEAR.parse(year);
    }

    public Date parseEndDate(String dateString) {
        try {
            if (this.isRange) {
                return this.parseRange(dateString, 1);
            }
            throw new RuntimeException("Attempting to parse non-range date as a range:  '" + dateString + "'");
        }
        catch (ParseException parseException) {
            throw new ValidationException("Could not format date of type '" + (Object)((Object)this) + "' with date string '" + dateString + "'");
        }
    }

    public static EDI_TIME_FORMAT parseString(String ediString) {
        EDI_TIME_FORMAT[] eDI_TIME_FORMATArray = EDI_TIME_FORMAT.values();
        int n = eDI_TIME_FORMATArray.length;
        int n2 = 0;
        while (n2 < n) {
            EDI_TIME_FORMAT currentTimeFormat = eDI_TIME_FORMATArray[n2];
            if (currentTimeFormat.getEdiValue().equals(ediString)) {
                return currentTimeFormat;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown time format : " + ediString);
    }
}

