/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.NameableType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.NameableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.sdmx.util.beans.ValidationUtil;
import org.sdmxsource.util.ObjectUtil;

public abstract class NameableBeanImpl
extends IdentifiableBeanImpl
implements NameableBean {
    private static final long serialVersionUID = 1L;
    protected List<TextTypeWrapper> name = new ArrayList<TextTypeWrapper>();
    List<TextTypeWrapper> description = new ArrayList<TextTypeWrapper>();

    protected NameableBeanImpl(NameableBean bean) {
        super(bean);
        this.name = bean.getNames();
        this.validateNameableAttributes();
    }

    protected NameableBeanImpl(NameableMutableBean bean, IdentifiableBean parent) {
        super(bean, (SdmxStructureBean)parent);
        if (bean.getName() != null) {
            for (TextTypeWrapperMutableBean mutable : bean.getName()) {
                if (!ObjectUtil.validString(mutable.getValue())) continue;
                this.name.add(new TextTypeWrapperImpl(mutable, (SDMXBean)this));
            }
        }
        if (bean.getDescription() != null) {
            for (TextTypeWrapperMutableBean mutable : bean.getDescription()) {
                if (!ObjectUtil.validString(mutable.getValue())) continue;
                this.description.add(new TextTypeWrapperImpl(mutable, (SDMXBean)this));
            }
        }
        this.validateNameableAttributes();
    }

    public NameableBeanImpl(NameableType createdFrom, SDMX_STRUCTURE_TYPE structureType, IdentifiableBean parent) {
        super(createdFrom, structureType, (SdmxStructureBean)parent);
        this.name = TextTypeUtil.wrapTextTypeV21(createdFrom.getNameList(), this);
        this.description = TextTypeUtil.wrapTextTypeV21(createdFrom.getDescriptionList(), this);
        this.validateNameableAttributes();
    }

    public NameableBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, String id, String uri, List<TextType> name, List<TextType> description, org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationsType annotationsType, IdentifiableBean parent) {
        super(createdFrom, structureType, id, uri, annotationsType, (SdmxStructureBean)parent);
        this.name = TextTypeUtil.wrapTextTypeV2(name, this);
        this.description = TextTypeUtil.wrapTextTypeV2(description, this);
        this.validateNameableAttributes();
    }

    public NameableBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, String id, String uri, List<org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType> name, List<org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType> description, AnnotationsType annotationsType, IdentifiableBean parent) {
        super(createdFrom, structureType, id, uri, annotationsType, (SdmxStructureBean)parent);
        this.name = TextTypeUtil.wrapTextTypeV1(name, this);
        this.description = TextTypeUtil.wrapTextTypeV1(description, this);
        this.validateNameableAttributes();
    }

    protected void validateNameableAttributes() throws ValidationException {
        if (this.structureType != SDMX_STRUCTURE_TYPE.SUBSCRIPTION && this.structureType != SDMX_STRUCTURE_TYPE.REGISTRATION) {
            if (this.name == null || this.name.size() == 0) {
                throw new ValidationException(ExceptionCode.STRUCTURE_IDENTIFIABLE_MISSING_NAME, (Object)((Object)this.structureType) + "  " + this.getId());
            }
            ValidationUtil.validateTextType(this.name, "");
            ValidationUtil.validateTextType(this.description, null);
        }
    }

    protected boolean deepEqualsInternal(NameableBean bean) {
        if (!super.equivalent(this.name, bean.getNames())) {
            return false;
        }
        if (!super.equivalent(this.description, bean.getDescriptions())) {
            return false;
        }
        return super.deepEqualsInternal(bean);
    }

    @Override
    public List<TextTypeWrapper> getNames() {
        return new ArrayList<TextTypeWrapper>(this.name);
    }

    @Override
    public List<TextTypeWrapper> getAllTextTypes() {
        List<TextTypeWrapper> returnList = super.getAllTextTypes();
        returnList.addAll(this.name);
        returnList.addAll(this.description);
        return returnList;
    }

    @Override
    public String getName() {
        TextTypeWrapper ttw = TextTypeUtil.getDefaultLocale(this.name);
        return ttw == null ? null : ttw.getValue();
    }

    @Override
    public List<TextTypeWrapper> getDescriptions() {
        return new ArrayList<TextTypeWrapper>(this.description);
    }

    @Override
    public String getDescription() {
        TextTypeWrapper ttw = TextTypeUtil.getDefaultLocale(this.description);
        return ttw == null ? null : ttw.getValue();
    }
}

