/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.ItemSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme.ConceptBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ConceptSchemeBeanImpl
extends ItemSchemeBeanImpl<ConceptBean>
implements ConceptSchemeBean {
    private static Logger LOG = Logger.getLogger(ConceptSchemeBean.class);
    private static final long serialVersionUID = 1L;

    private ConceptSchemeBeanImpl(ConceptSchemeBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
        LOG.debug((Object)"Stub ConceptSchemeBean Built");
    }

    public ConceptSchemeBeanImpl(ConceptSchemeMutableBean conceptScheme) {
        super(conceptScheme);
        LOG.debug((Object)"Building ConceptSchemeBean from Mutable Bean");
        try {
            if (conceptScheme.getItems() != null) {
                for (ConceptMutableBean concept : conceptScheme.getItems()) {
                    this.items.add(new ConceptBeanImpl((ConceptSchemeBean)this, concept));
                }
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ConceptSchemeBean Built " + this.getUrn()));
        }
    }

    public ConceptSchemeBeanImpl(ConceptSchemeType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
        LOG.debug((Object)"Building ConceptSchemeBean from 2.1 SDMX");
        try {
            for (ConceptType currentItem : bean.getConceptList()) {
                this.items.add(new ConceptBeanImpl((ConceptSchemeBean)this, currentItem));
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ConceptSchemeBean Built " + this.getUrn()));
        }
    }

    public ConceptSchemeBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), ConceptSchemeBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), ConceptSchemeBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        LOG.debug((Object)"Building ConceptSchemeBean from 2.0 SDMX");
        try {
            for (org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType currentItem : bean.getConceptList()) {
                this.items.add(new ConceptBeanImpl((ConceptSchemeBean)this, currentItem));
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ConceptSchemeBean Built " + this.getUrn()));
        }
    }

    public ConceptSchemeBeanImpl(List<org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType> concepts, String agencyId) {
        super(null, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, null, null, "1.0", TERTIARY_BOOL.FALSE, agencyId, "STANDALONE_CONCEPT_SCHEME", null, ConceptSchemeBeanImpl.getDefaultName(), null, TERTIARY_BOOL.FALSE, null);
        LOG.debug((Object)"Building ConceptSchemeBean from Stand Alone 2.0 Concepts");
        try {
            for (org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptType currentItem : concepts) {
                if (!currentItem.getAgencyID().equals(this.getAgencyId())) {
                    throw new ValidationException(ExceptionCode.FAIL_VALIDATION, "Attempting to create Default Concept Scheme from v1.0 List of concepts, and was provided with a concept that reference different agency reference ('" + currentItem.getAgencyID() + "') to the scheme agency ('" + this.getAgencyId() + "')");
                }
                this.items.add(new ConceptBeanImpl((ConceptSchemeBean)this, currentItem));
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ConceptSchemeBean Built " + this.getUrn()));
        }
    }

    public ConceptSchemeBeanImpl(String agencyId, List<org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ConceptType> concepts) {
        super(null, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, null, null, "1.0", TERTIARY_BOOL.FALSE, agencyId, "STANDALONE_CONCEPT_SCHEME", null, ConceptSchemeBeanImpl.getDefaultName(), null, TERTIARY_BOOL.FALSE, null);
        LOG.debug((Object)"Building ConceptSchemeBean from 1.0 SDMX");
        try {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ConceptType currentItem : concepts) {
                if (!currentItem.getAgency().equals(this.getAgencyId())) {
                    throw new ValidationException(ExceptionCode.FAIL_VALIDATION, "Attempting to create Default Concept Scheme from v1.0 List of concepts, and was provided with a concept that reference different agency reference ('" + currentItem.getAgency() + "') to the scheme agency ('" + this.getAgencyId() + "')");
                }
                this.items.add(new ConceptBeanImpl((ConceptSchemeBean)this, currentItem));
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ConceptSchemeBean Built " + this.getUrn()));
        }
    }

    private static List<TextType> getDefaultName() {
        ArrayList<TextType> returnList = new ArrayList<TextType>();
        TextType tt = TextType.Factory.newInstance();
        tt.setStringValue("Default Scheme");
        returnList.add(tt);
        return returnList;
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            return super.deepEqualsInternal((ConceptSchemeBean)bean);
        }
        return false;
    }

    private void validate() throws ValidationException {
        HashSet<String> urns = new HashSet<String>();
        if (this.getId().equals("STANDALONE_CONCEPT_SCHEME")) {
            if (!this.getVersion().equals("1.0")) {
                throw new ValidationException(ExceptionCode.FAIL_VALIDATION, "STANDALONE_CONCEPT_SCHEME can only be version 1.0");
            }
            if (this.isFinal.isTrue()) {
                throw new ValidationException(ExceptionCode.FAIL_VALIDATION, "STANDALONE_CONCEPT_SCHEME can not be made final");
            }
        }
        if (this.items != null) {
            HashMap<ConceptBean, Set<ConceptBean>> parentChildMap = new HashMap<ConceptBean, Set<ConceptBean>>();
            for (ConceptBean concept : this.items) {
                if (urns.contains(concept.getUrn())) {
                    throw new ValidationException(ExceptionCode.DUPLICATE_URN, concept.getUrn());
                }
                urns.add(concept.getUrn());
                try {
                    Set<ConceptBean> children;
                    if (!ObjectUtil.validString(concept.getParentConcept())) continue;
                    ConceptBean parent = this.getConceptBean(this.items, concept.getParentConcept());
                    if (parentChildMap.containsKey(parent)) {
                        children = (Set)parentChildMap.get(parent);
                    } else {
                        children = new HashSet();
                        parentChildMap.put(parent, children);
                    }
                    children.add(concept);
                    this.recurseParentMap((Set)parentChildMap.get(concept), parent, parentChildMap);
                }
                catch (ValidationException e) {
                    throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, concept.toString());
                }
            }
        }
    }

    @Override
    protected void validateId(boolean startWithIntAllowed) {
        super.validateId(false);
    }

    private void recurseParentMap(Set<ConceptBean> children, ConceptBean parent, Map<ConceptBean, Set<ConceptBean>> parentChildMap) {
        if (children != null) {
            if (children.contains(parent)) {
                throw new ValidationException(ExceptionCode.PARENT_RECURSIVE_LOOP, parent.getId());
            }
            for (ConceptBean currentChild : children) {
                this.recurseParentMap(parentChildMap.get(currentChild), parent, parentChildMap);
            }
        }
    }

    private ConceptBean getConceptBean(List<ConceptBean> concepts, String id) {
        for (ConceptBean currentBean : concepts) {
            if (!currentBean.getId().equals(id)) continue;
            return currentBean;
        }
        throw new ValidationException(ExceptionCode.CAN_NOT_RESOLVE_PARENT, id);
    }

    @Override
    public ConceptSchemeBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new ConceptSchemeBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public boolean isDefaultScheme() {
        return this.getId().equals("STANDALONE_CONCEPT_SCHEME");
    }

    @Override
    public ConceptSchemeMutableBean getMutableInstance() {
        return new ConceptSchemeMutableBeanImpl(this);
    }
}

