/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmx.resources.sdmxml.schemas.v20.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CrossSectionalMeasureType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DimensionType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TimeDimensionType;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalDataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.CrossSectionalMeasureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalDataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.CrossSectionalMeasureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.CrossSectionalMeasureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.CrossSectionalDataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CrossSectionalDataStructureBeanImpl
extends DataStructureBeanImpl
implements CrossSectionalDataStructureBean {
    private static final long serialVersionUID = 6854980059046880882L;
    private List<CrossSectionalMeasureBean> crossSectionalMeasures = new ArrayList<CrossSectionalMeasureBean>();
    private List<ComponentBean> crossSectionalAttachDataSet = new ArrayList<ComponentBean>();
    private List<ComponentBean> crossSectionalAttachGroup = new ArrayList<ComponentBean>();
    private List<ComponentBean> crossSectionalAttachSection = new ArrayList<ComponentBean>();
    private List<ComponentBean> crossSectionalAttachObservation = new ArrayList<ComponentBean>();
    private Map<String, List<CrossSectionalMeasureBean>> attributeToMeasuresMap = new HashMap<String, List<CrossSectionalMeasureBean>>();
    private List<String> measureDimensions = new ArrayList<String>();
    private Map<String, CrossReferenceBean> codelistMap = new HashMap<String, CrossReferenceBean>();

    public CrossSectionalDataStructureBeanImpl(CrossSectionalDataStructureMutableBean bean) {
        super(bean);
        if (bean.getCrossSectionalMeasures() != null) {
            for (CrossSectionalMeasureMutableBean currentMeasure : bean.getCrossSectionalMeasures()) {
                this.crossSectionalMeasures.add(new CrossSectionalMeasureBeanImpl(currentMeasure, this));
            }
        }
        if (bean.getMeasureDimensionCodelistMapping() != null) {
            for (String currentCodelist : bean.getMeasureDimensionCodelistMapping().keySet()) {
                this.codelistMap.put(currentCodelist, new CrossReferenceBeanImpl((SDMXBean)this, bean.getMeasureDimensionCodelistMapping().get(currentCodelist)));
            }
        }
        for (DimensionMutableBean dim : bean.getDimensions()) {
            if (!dim.isMeasureDimension()) continue;
            this.measureDimensions.add(dim.getConceptRef().getIdentifiableIds()[0]);
        }
        if (bean.getCrossSectionalAttachDataSet() != null) {
            for (String componentId : bean.getCrossSectionalAttachDataSet()) {
                this.addComponentToList(componentId, this.crossSectionalAttachDataSet);
            }
        }
        if (bean.getCrossSectionalAttachGroup() != null) {
            for (String componentId : bean.getCrossSectionalAttachGroup()) {
                this.addComponentToList(componentId, this.crossSectionalAttachGroup);
            }
        }
        if (bean.getCrossSectionalAttachSection() != null) {
            for (String componentId : bean.getCrossSectionalAttachSection()) {
                this.addComponentToList(componentId, this.crossSectionalAttachSection);
            }
        }
        if (bean.getCrossSectionalAttachObservation() != null) {
            for (String componentId : bean.getCrossSectionalAttachObservation()) {
                this.addComponentToList(componentId, this.crossSectionalAttachObservation);
            }
        }
        if (bean.getAttributeToMeasureMap() != null) {
            for (String attributeId : bean.getAttributeToMeasureMap().keySet()) {
                this.setAttributeMeasures(attributeId, bean.getAttributeToMeasureMap().get(attributeId));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    @Override
    public CrossReferenceBean getCodelistForMeasureDimension(String dimensionId) {
        return this.codelistMap.get(dimensionId);
    }

    @Override
    public boolean isMeasureDimension(DimensionBean dim) {
        return this.measureDimensions.contains(dim.getId());
    }

    public CrossSectionalDataStructureBeanImpl(KeyFamilyType bean) {
        super(bean);
        String componentId;
        if (bean.getComponents() == null || !ObjectUtil.validCollection(bean.getComponents().getCrossSectionalMeasureList())) {
            throw new ValidationException("Can not create CrossSectionalDataStructureBean as there are no CrossSectional Measures defined");
        }
        for (CrossSectionalMeasureType crossSectionalMeasureType : bean.getComponents().getCrossSectionalMeasureList()) {
            this.crossSectionalMeasures.add(new CrossSectionalMeasureBeanImpl(crossSectionalMeasureType, (IdentifiableBean)this));
        }
        for (DimensionType dimensionType : bean.getComponents().getDimensionList()) {
            componentId = dimensionType.getConceptRef();
            if (dimensionType.getIsMeasureDimension()) {
                this.measureDimensions.add(componentId);
                String codelistAgency = dimensionType.getCodelistAgency();
                if (!ObjectUtil.validString(codelistAgency)) {
                    codelistAgency = this.getAgencyId();
                }
                CrossReferenceBeanImpl codelistRef = new CrossReferenceBeanImpl(this, codelistAgency, dimensionType.getCodelist(), dimensionType.getCodelistVersion(), SDMX_STRUCTURE_TYPE.CODE_LIST);
                this.codelistMap.put(componentId, codelistRef);
            }
            if (dimensionType.getCrossSectionalAttachDataSet()) {
                this.addComponentToList(componentId, this.crossSectionalAttachDataSet);
            }
            if (dimensionType.getCrossSectionalAttachGroup()) {
                this.addComponentToList(componentId, this.crossSectionalAttachGroup);
            }
            if (dimensionType.getCrossSectionalAttachObservation()) {
                this.addComponentToList(componentId, this.crossSectionalAttachObservation);
            }
            if (!dimensionType.getCrossSectionalAttachSection()) continue;
            this.addComponentToList(componentId, this.crossSectionalAttachSection);
        }
        for (AttributeType attributeType : bean.getComponents().getAttributeList()) {
            componentId = attributeType.getConceptRef();
            if (attributeType.getCrossSectionalAttachDataSet()) {
                this.addComponentToList(componentId, this.crossSectionalAttachDataSet);
            }
            if (attributeType.getCrossSectionalAttachGroup()) {
                this.addComponentToList(componentId, this.crossSectionalAttachGroup);
            }
            if (attributeType.getCrossSectionalAttachObservation()) {
                this.addComponentToList(componentId, this.crossSectionalAttachObservation);
            }
            if (attributeType.getCrossSectionalAttachSection()) {
                this.addComponentToList(componentId, this.crossSectionalAttachSection);
            }
            this.setAttributeMeasures(componentId, attributeType.getAttachmentMeasureList());
        }
        if (bean.getComponents().getTimeDimension() != null) {
            TimeDimensionType currentComponent = bean.getComponents().getTimeDimension();
            String string = currentComponent.getConceptRef();
            if (currentComponent.getCrossSectionalAttachDataSet()) {
                this.addComponentToList(string, this.crossSectionalAttachDataSet);
            }
            if (currentComponent.getCrossSectionalAttachGroup()) {
                this.addComponentToList(string, this.crossSectionalAttachGroup);
            }
            if (currentComponent.getCrossSectionalAttachObservation()) {
                this.addComponentToList(string, this.crossSectionalAttachObservation);
            }
            if (currentComponent.getCrossSectionalAttachSection()) {
                this.addComponentToList(string, this.crossSectionalAttachSection);
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    private void addComponentToList(String componentId, List<ComponentBean> listToAddTo) {
        ComponentBean component = this.getComponent(componentId);
        if (component == null) {
            throw new ValidationException("Can not find referenced component with id " + componentId);
        }
        listToAddTo.add(component);
    }

    private void setAttributeMeasures(String attributeId, List<String> measureIds) {
        if (measureIds == null) {
            return;
        }
        try {
            ComponentBean component = this.getComponent(attributeId);
            if (component == null) {
                throw new ValidationException("Could not resolve reference to attribute with id '" + attributeId + "' " + "referenced from cross sectional data structure");
            }
            if (component instanceof AttributeBean) {
                AttributeBean att = (AttributeBean)component;
                if (att.getAttachmentLevel() != ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION) {
                    throw new ValidationException("Attribute '" + attributeId + "' is referencing cross sectional measure, the attribute " + "must have an attachment level of Observation, it is currently set to '" + (Object)((Object)att.getAttachmentLevel()) + "'");
                }
            } else {
                throw new ValidationException("Cross Sectional Measure attribute reference id '" + attributeId + "' " + "is referencing structure of type '" + component.getStructureType().getType() + "'");
            }
            ArrayList<CrossSectionalMeasureBean> measureList = new ArrayList<CrossSectionalMeasureBean>();
            for (String measureId : measureIds) {
                if (measureId == null) continue;
                CrossSectionalMeasureBean crossSectionalMeasure = this.getCrossSectionalMeasure(measureId);
                if (crossSectionalMeasure == null) {
                    throw new ValidationException("Could not resolve reference to cross sectional measure with id '" + measureId + "' " + "referenced from attribute '" + attributeId + "'");
                }
                measureList.add(crossSectionalMeasure);
            }
            this.attributeToMeasuresMap.put(attributeId, measureList);
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.toString());
        }
    }

    private void validate() {
    }

    @Override
    public List<CrossSectionalMeasureBean> getAttachmentMeasures(AttributeBean attribute) {
        if (this.attributeToMeasuresMap.containsKey(attribute.getId())) {
            return this.attributeToMeasuresMap.get(attribute.getId());
        }
        return new ArrayList<CrossSectionalMeasureBean>();
    }

    @Override
    public CrossSectionalDataStructureMutableBean getMutableInstance() {
        return new CrossSectionalDataStructureMutableBeanImpl(this);
    }

    @Override
    public CrossSectionalMeasureBean getCrossSectionalMeasure(String id) {
        for (CrossSectionalMeasureBean currentMeasure : this.crossSectionalMeasures) {
            if (!currentMeasure.getId().equals(id)) continue;
            return currentMeasure;
        }
        return null;
    }

    @Override
    public List<CrossSectionalMeasureBean> getCrossSectionalMeasures() {
        return new ArrayList<CrossSectionalMeasureBean>(this.crossSectionalMeasures);
    }

    @Override
    public List<ComponentBean> getCrossSectionalAttachDataSet(boolean returnOnlyIfLowestLevel, SDMX_STRUCTURE_TYPE ... returnTypes) {
        List<ComponentBean> returnList = this.getComponets(this.crossSectionalAttachDataSet, returnTypes);
        if (returnOnlyIfLowestLevel) {
            returnList.removeAll(this.crossSectionalAttachGroup);
            returnList.removeAll(this.crossSectionalAttachSection);
            returnList.removeAll(this.crossSectionalAttachObservation);
        }
        return returnList;
    }

    @Override
    public List<ComponentBean> getCrossSectionalAttachGroup(boolean returnOnlyIfLowestLevel, SDMX_STRUCTURE_TYPE ... returnTypes) {
        List<ComponentBean> returnList = this.getComponets(this.crossSectionalAttachGroup, returnTypes);
        if (returnOnlyIfLowestLevel) {
            returnList.removeAll(this.crossSectionalAttachSection);
            returnList.removeAll(this.crossSectionalAttachObservation);
        }
        return returnList;
    }

    @Override
    public List<ComponentBean> getCrossSectionalAttachSection(boolean returnOnlyIfLowestLevel, SDMX_STRUCTURE_TYPE ... returnTypes) {
        List<ComponentBean> returnList = this.getComponets(this.crossSectionalAttachSection, returnTypes);
        if (returnOnlyIfLowestLevel) {
            returnList.removeAll(this.crossSectionalAttachObservation);
        }
        return returnList;
    }

    @Override
    public List<ComponentBean> getCrossSectionalAttachObservation(SDMX_STRUCTURE_TYPE ... returnTypes) {
        return this.getComponets(this.crossSectionalAttachObservation, returnTypes);
    }

    private List<ComponentBean> getComponets(List<ComponentBean> listToGetFrom, SDMX_STRUCTURE_TYPE ... returnTypes) {
        ArrayList<ComponentBean> returnList = new ArrayList<ComponentBean>();
        for (ComponentBean currentComponentBean : listToGetFrom) {
            if (!this.isValidReturnType(currentComponentBean, returnTypes)) continue;
            returnList.add(currentComponentBean);
        }
        return returnList;
    }

    private boolean isValidReturnType(ComponentBean component, SDMX_STRUCTURE_TYPE ... returnTypes) {
        if (returnTypes == null || returnTypes.length == 0) {
            return true;
        }
        for (SDMX_STRUCTURE_TYPE currentRetrunType : returnTypes) {
            if (component.getStructureType() != currentRetrunType) continue;
            return true;
        }
        return false;
    }
}

