/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyRefType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;

public class DataflowBeanImpl
extends MaintainableBeanImpl
implements DataflowBean {
    private static Logger LOG = Logger.getLogger(DataflowBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private CrossReferenceBean keyFamilyRef;

    private DataflowBeanImpl(DataflowBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
        LOG.debug((Object)"Stub DataflowBean Built");
    }

    public DataflowBeanImpl(DataflowMutableBean bean) {
        super(bean);
        LOG.debug((Object)"Building DataflowBean from Mutable Bean");
        if (bean.getDataStructureRef() != null) {
            this.keyFamilyRef = new CrossReferenceBeanImpl((SDMXBean)this, bean.getDataStructureRef());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataflowBean Built " + this.getUrn()));
        }
    }

    public DataflowBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.DataflowType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.DATAFLOW);
        LOG.debug((Object)"Building DataflowBean from 2.1 SDMX");
        if (bean.getStructure() != null) {
            this.keyFamilyRef = RefUtil.createReference(this, bean.getStructure());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataflowBean Built " + this.getUrn()));
        }
    }

    public DataflowBeanImpl(DataflowType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.DATAFLOW, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), DataflowBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), DataflowBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        LOG.debug((Object)"Building DataflowBean from 2.0 SDMX");
        if (bean.getKeyFamilyRef() != null) {
            KeyFamilyRefType kfRef = bean.getKeyFamilyRef();
            this.keyFamilyRef = kfRef.getURN() != null ? new CrossReferenceBeanImpl((SDMXBean)this, kfRef.getURN()) : new CrossReferenceBeanImpl(this, kfRef.getKeyFamilyAgencyID(), kfRef.getKeyFamilyID(), kfRef.getVersion(), SDMX_STRUCTURE_TYPE.DSD);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DataflowBean Built " + this.getUrn()));
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            DataflowBean that = (DataflowBean)bean;
            if (!super.equivalent(this.keyFamilyRef, that.getDataStructureRef())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (this.keyFamilyRef == null) {
            throw new ValidationException("Dataflow must reference a Data Structure Definition");
        }
    }

    @Override
    public DataflowBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new DataflowBeanImpl(this, actualLocation, isServiceUrl);
    }

    @Override
    public DataflowMutableBean getMutableInstance() {
        return new DataflowMutableBeanImpl(this);
    }

    @Override
    public List<CrossReferenceBean> getCrossReferencedConstrainables() {
        ArrayList<CrossReferenceBean> returnList = new ArrayList<CrossReferenceBean>();
        returnList.add(this.getDataStructureRef());
        return returnList;
    }

    @Override
    public CrossReferenceBean getDataStructureRef() {
        return this.keyFamilyRef;
    }
}

