/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataAttributeType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalMetadataTargetReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportStructureType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.StructureException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportStructureBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.MetadataAttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.metadatastructure.ReportStructureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.IdentifiableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataAttributeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.util.ObjectUtil;

public class ReportStructureBeanImpl
extends IdentifiableBeanImpl
implements ReportStructureBean {
    private static final long serialVersionUID = 1L;
    private List<MetadataAttributeBean> metadataAttributes = new ArrayList<MetadataAttributeBean>();
    private List<String> targetMetadatas = new ArrayList<String>();

    public ReportStructureBeanImpl(MetadataStructureDefinitionBean parent, ReportStructureMutableBean rs) {
        super(rs, (SdmxStructureBean)parent);
        try {
            if (rs.getMetadataAttributes() != null) {
                for (MetadataAttributeMutableBean currentMa : rs.getMetadataAttributes()) {
                    this.metadataAttributes.add(new MetadataAttributeBeanImpl((IdentifiableBean)this, currentMa));
                }
            }
            if (rs.getTargetMetadatas() != null) {
                this.targetMetadatas = new ArrayList<String>(rs.getTargetMetadatas());
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    public ReportStructureBeanImpl(MetadataStructureDefinitionBean parent, ReportStructureType rs) {
        super(rs, SDMX_STRUCTURE_TYPE.REPORT_STRUCTURE, (SdmxStructureBean)parent);
        try {
            for (org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataAttributeType currentMa : rs.getMetadataAttributeList()) {
                this.metadataAttributes.add(new MetadataAttributeBeanImpl(currentMa, (IdentifiableBean)this));
            }
            if (rs.getMetadataTargetList() != null) {
                for (LocalMetadataTargetReferenceType mtRefType : rs.getMetadataTargetList()) {
                    this.targetMetadatas.add(RefUtil.createLocalIdReference(mtRefType));
                }
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    public ReportStructureBeanImpl(MetadataStructureDefinitionBean parent, org.sdmx.resources.sdmxml.schemas.v20.structure.ReportStructureType rs) {
        super((XmlObject)rs, SDMX_STRUCTURE_TYPE.REPORT_STRUCTURE, rs.getId(), rs.getUri(), rs.getAnnotations(), (SdmxStructureBean)parent);
        try {
            for (MetadataAttributeType currentMa : rs.getMetadataAttributeList()) {
                this.metadataAttributes.add(new MetadataAttributeBeanImpl((IdentifiableBean)this, currentMa));
            }
            if (ObjectUtil.validString(rs.getTarget())) {
                this.targetMetadatas.add(rs.getTarget());
            }
        }
        catch (Throwable th) {
            throw new StructureException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, this.getUrn());
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new ValidationException(e, ExceptionCode.FAIL_VALIDATION, this.getUrn());
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ReportStructureBean that = (ReportStructureBean)bean;
            if (!super.equivalent(this.metadataAttributes, that.getMetadataAttributes())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.targetMetadatas, that.getTargetMetadatas())) {
                return false;
            }
            return super.deepEqualsInternal(that);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (!ObjectUtil.validCollection(this.metadataAttributes)) {
            throw new ValidationException("Report Structure requires at least one Metadata Attribute");
        }
        if (!ObjectUtil.validCollection(this.targetMetadatas)) {
            throw new ValidationException("Report Structure requires at least one Metadata Target");
        }
    }

    @Override
    public List<MetadataAttributeBean> getMetadataAttributes() {
        return new ArrayList<MetadataAttributeBean>(this.metadataAttributes);
    }

    @Override
    public List<String> getTargetMetadatas() {
        return new ArrayList<String>(this.targetMetadatas);
    }
}

