/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.reference;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class RESTSchemaQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StructureReferenceBean reference;
    private String dimAtObs;
    private boolean explicitMeasure;
    private String context;
    private String agencyId;
    private String id;
    private String version;

    public RESTSchemaQuery(String restString) {
        String queryString = restString.substring(restString.indexOf("schema/"));
        String[] queryStringArr = queryString.split("/");
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (queryString.indexOf("?") > 0) {
            String params = queryString.substring(queryString.indexOf("?") + 1);
            queryString = queryString.substring(0, queryString.indexOf("?"));
            for (String currentParam : params.split("&")) {
                String[] param = currentParam.split("=");
                queryParameters.put(param[0], param[1]);
            }
        }
        this.evaluate(queryStringArr, queryParameters);
    }

    public RESTSchemaQuery(String[] queryString, Map<String, String> queryParameters) {
        this.evaluate(queryString, queryParameters);
    }

    private void evaluate(String[] queryString, Map<String, String> queryParameters) {
        this.parseQueryString(queryString);
        this.parseQueryParameters(queryParameters);
        SDMX_STRUCTURE_TYPE referencedStructure = SDMX_STRUCTURE_TYPE.parseClass(this.context);
        if (referencedStructure != SDMX_STRUCTURE_TYPE.DSD && referencedStructure != SDMX_STRUCTURE_TYPE.DATAFLOW && referencedStructure != SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT && referencedStructure != SDMX_STRUCTURE_TYPE.METADATA_FLOW && referencedStructure != SDMX_STRUCTURE_TYPE.MSD) {
            throw new ValidationException("The referenced structure is not a legitimate type!");
        }
        MaintainableRefBeanImpl ref = new MaintainableRefBeanImpl(this.agencyId, this.id, this.version);
        this.reference = new StructureReferenceBeanImpl(ref, referencedStructure);
    }

    private void parseQueryString(String[] queryString) {
        if (queryString.length < 2) {
            throw new ValidationException("Schema query expected to contain context as the second argument");
        }
        this.context = queryString[1];
        if (queryString.length < 3) {
            throw new ValidationException("Schema query expected to contain Agency ID as the third argument");
        }
        this.agencyId = queryString[2];
        if (queryString.length < 4) {
            throw new ValidationException("Schema query expected to contain Resource ID as the fourth argument");
        }
        this.id = queryString[3];
        if (queryString.length > 4) {
            this.version = queryString[4];
            if (this.version.equalsIgnoreCase("latest")) {
                this.version = null;
            }
        }
        if (queryString.length > 5) {
            throw new ValidationException("Schema query has unexpected sixth argument");
        }
    }

    private void parseQueryParameters(Map<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                if (key.equalsIgnoreCase("dimensionAtObservation")) {
                    this.dimAtObs = params.get(key);
                    continue;
                }
                if (key.equalsIgnoreCase("explicitMeasure")) {
                    String val = params.get(key);
                    this.explicitMeasure = Boolean.parseBoolean(val);
                    continue;
                }
                throw new ValidationException("Unknown query parameter : " + key + " allowed parameters [dimensionAtObservation, explicitMeasure]");
            }
        }
    }

    public StructureReferenceBean getReference() {
        return this.reference;
    }

    public String getDimAtObs() {
        return this.dimAtObs;
    }

    public boolean isExplicitMeasure() {
        return this.explicitMeasure;
    }
}

