/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.reference;

import java.io.Serializable;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_REFERENCE_DETAIL;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureQuery;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureQueryMetadata;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.StructureQueryMetadataImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RESTStructureQuery
implements StructureQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    private StructureReferenceBean structureReference;
    private StructureQueryMetadata structureQueryMetadata = new StructureQueryMetadataImpl(null, null, null, true);

    public RESTStructureQuery(StructureReferenceBean structureReference) {
        this.structureReference = structureReference;
    }

    public RESTStructureQuery(STRUCTURE_QUERY_DETAIL structureQueryDetail, STRUCTURE_REFERENCE_DETAIL structureReferenceDetail, SDMX_STRUCTURE_TYPE specificStructureReference, StructureReferenceBean structureReference, boolean returnLatest) {
        this.structureQueryMetadata = new StructureQueryMetadataImpl(structureQueryDetail, structureReferenceDetail, specificStructureReference, returnLatest);
        this.structureReference = structureReference;
    }

    public RESTStructureQuery(String[] queryString, Map<String, String> queryParameters) {
        this.parserQueryString(queryString);
        this.structureQueryMetadata = new StructureQueryMetadataImpl(queryString, queryParameters);
    }

    @Override
    public StructureQueryMetadata getStructureQueryMetadata() {
        return this.structureQueryMetadata;
    }

    @Override
    public StructureReferenceBean getStructureReference() {
        return this.structureReference;
    }

    private void parserQueryString(String[] queryString) {
        if (queryString.length < 1) {
            throw new ValidationException("Structure Query Expecting at least 1 parameter (structure type)");
        }
        SDMX_STRUCTURE_TYPE structureType = RESTStructureQuery.getStructureType(queryString[0]);
        String agencyId = null;
        String id = null;
        String version = null;
        if (queryString.length >= 2) {
            agencyId = this.parseQueryString(queryString[1]);
        }
        if (queryString.length >= 3) {
            id = this.parseQueryString(queryString[2]);
        }
        if (queryString.length >= 4) {
            version = this.parseQueryString(queryString[3]);
        }
        this.structureReference = new StructureReferenceBeanImpl(agencyId, id, version, structureType, new String[0]);
    }

    private String parseQueryString(String query) {
        if (!ObjectUtil.validString(query)) {
            return null;
        }
        if (query.equalsIgnoreCase("ALL")) {
            return null;
        }
        if (query.equalsIgnoreCase("LATEST")) {
            return null;
        }
        return query;
    }

    private static SDMX_STRUCTURE_TYPE getStructureType(String str) {
        if (str.equalsIgnoreCase("structure")) {
            return SDMX_STRUCTURE_TYPE.ANY;
        }
        if (str.equalsIgnoreCase("organisationscheme")) {
            return SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME;
        }
        return SDMX_STRUCTURE_TYPE.parseClass(str);
    }

    public String toString() {
        return "ref: " + this.structureReference + "-detail:" + (Object)((Object)this.structureQueryMetadata.getStructureQueryDetail()) + "-references:" + this.structureReference + "-specific" + (Object)((Object)this.structureQueryMetadata.getSpecificStructureReference()) + "latest" + this.structureQueryMetadata.isReturnLatest();
    }
}

