/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.MaintainableReferenceBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.common.QueryableDataSourceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SetReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintAttachmentType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.DataAndMetadataSetReference;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintAttachmentBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintBean;
import org.sdmxsource.sdmx.api.model.mutable.base.DataSourceMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ConstraintAttachmentMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataSourceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.DataAndMetadataSetReferenceImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ContentConstraintAttachmentMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ConstraintAttachmentBeanImpl
extends SdmxStructureBeanImpl
implements ConstraintAttachmentBean {
    private static final long serialVersionUID = -1569557335515629246L;
    private DataAndMetadataSetReference dataOrMetadataSetReference;
    private Set<CrossReferenceBean> crossReference = new HashSet<CrossReferenceBean>();
    private List<DataSourceBean> dataSources = new ArrayList<DataSourceBean>();

    public ConstraintAttachmentBeanImpl(ConstraintAttachmentMutableBean mutable, ConstraintBean constraint) {
        super(SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT_ATTACHMENT, (SdmxStructureBean)constraint);
        if (mutable.getDataOrMetadataSetReference() != null) {
            this.dataOrMetadataSetReference = new DataAndMetadataSetReferenceImpl(mutable.getDataOrMetadataSetReference());
        }
        if (mutable.getStructureReference() != null) {
            for (StructureReferenceBean sRef : mutable.getStructureReference()) {
                this.crossReference.add(new CrossReferenceBeanImpl((SDMXBean)this, sRef));
            }
        }
        if (ObjectUtil.validCollection(mutable.getDataSources())) {
            for (DataSourceMutableBean each : mutable.getDataSources()) {
                this.dataSources.add(new DataSourceBeanImpl(each, (SdmxStructureBean)this));
            }
        }
        this.validate();
    }

    public ConstraintAttachmentBeanImpl(ConstraintAttachmentType type, ConstraintBean constraint) {
        super(SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT_ATTACHMENT, (SdmxStructureBean)constraint);
        CrossReferenceBean ref;
        SetReferenceType setRef;
        if (type.getSimpleDataSourceList() != null) {
            for (String dataSource : type.getSimpleDataSourceList()) {
                this.dataSources.add(new DataSourceBeanImpl(dataSource, (SdmxStructureBean)this));
            }
        }
        if (type.getDataProvider() != null) {
            this.crossReference.add(RefUtil.createReference(this, type.getDataProvider()));
        }
        if (ObjectUtil.validCollection(type.getDataSetList())) {
            setRef = type.getDataSetList().get(0);
            ref = RefUtil.createReference(this, setRef.getDataProvider());
            this.dataOrMetadataSetReference = new DataAndMetadataSetReferenceImpl(ref, setRef.getID(), true);
        }
        if (ObjectUtil.validCollection(type.getMetadataSetList())) {
            setRef = type.getMetadataSetList().get(0);
            ref = RefUtil.createReference(this, setRef.getDataProvider());
            this.dataOrMetadataSetReference = new DataAndMetadataSetReferenceImpl(ref, setRef.getID(), false);
        }
        this.addRef(type.getDataStructureList());
        this.addRef(type.getMetadataStructureList());
        this.addRef(type.getDataflowList());
        this.addRef(type.getMetadataflowList());
        this.addRef(type.getProvisionAgreementList());
        for (QueryableDataSourceType queryableDataSource : type.getQueryableDataSourceList()) {
            this.dataSources.add(new DataSourceBeanImpl(queryableDataSource, (SdmxStructureBean)this));
        }
        this.validate();
    }

    private void addRef(List<? extends MaintainableReferenceBaseType> refListType) {
        if (ObjectUtil.validCollection(refListType)) {
            for (MaintainableReferenceBaseType maintainableReferenceBaseType : refListType) {
                CrossReferenceBean crossRef = RefUtil.createReference(this, maintainableReferenceBaseType);
                this.crossReference.add(crossRef);
            }
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            ConstraintAttachmentBean that = (ConstraintAttachmentBean)bean;
            if (!ObjectUtil.equivalent(this.dataOrMetadataSetReference, that.getDataOrMetadataSetReference())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.crossReference, that.getStructureReference())) {
                return false;
            }
            return super.equivalent(this.dataSources, that.getDataSources());
        }
        return false;
    }

    private void validate() throws ValidationException {
        SDMX_STRUCTURE_TYPE constrainingType = null;
        if (this.dataOrMetadataSetReference == null && !ObjectUtil.validCollection(this.crossReference) && !ObjectUtil.validCollection(this.dataSources)) {
            throw new ValidationException("The ContentConstraint doesn't have a Constraint Attachment defined");
        }
        for (CrossReferenceBean xsRef : this.crossReference) {
            if (constrainingType == null) {
                constrainingType = xsRef.getTargetReference();
                continue;
            }
            switch (xsRef.getTargetReference()) {
                case DSD: {
                    if (constrainingType == SDMX_STRUCTURE_TYPE.DATAFLOW || constrainingType == SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT) break;
                    constrainingType = xsRef.getTargetReference();
                    break;
                }
                case DATAFLOW: {
                    if (constrainingType == SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT) break;
                    constrainingType = xsRef.getTargetReference();
                    break;
                }
                case PROVISION_AGREEMENT: {
                    constrainingType = xsRef.getTargetReference();
                }
            }
        }
    }

    @Override
    public DataAndMetadataSetReference getDataOrMetadataSetReference() {
        return this.dataOrMetadataSetReference;
    }

    @Override
    public Set<CrossReferenceBean> getStructureReference() {
        return this.crossReference;
    }

    @Override
    public List<DataSourceBean> getDataSources() {
        return new ArrayList<DataSourceBean>(this.dataSources);
    }

    @Override
    public ConstraintAttachmentMutableBean createMutableInstance() {
        return new ContentConstraintAttachmentMutableBeanImpl(this);
    }
}

