/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SimpleValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TimeRangeBean;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.mutable.registry.KeyValuesMutable;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TimeRangeBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class KeyValuesImpl
extends SdmxStructureBeanImpl
implements KeyValues {
    private static final long serialVersionUID = 6742531633522333585L;
    private String id;
    private List<String> values = new ArrayList<String>();
    private List<String> caseCadeList = new ArrayList<String>();
    private TimeRangeBean timeRangeBean;

    public KeyValuesImpl(KeyValuesMutable mutable, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.KEY_VALUES, parent);
        this.id = mutable.getId();
        this.values.addAll(mutable.getKeyValues());
        for (String each : this.values) {
            if (!mutable.isCascadeValue(each)) continue;
            this.caseCadeList.add(each);
        }
        if (mutable.getTimeRange() != null) {
            this.timeRangeBean = new TimeRangeBeanImpl(mutable.getTimeRange(), (SdmxStructureBean)this);
        }
        this.validate();
    }

    public KeyValuesImpl(ComponentValueSetType keyValueType, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.KEY_VALUES, parent);
        this.id = keyValueType.getId();
        if (keyValueType.getValueList() != null) {
            for (SimpleValueType dataKeyType : keyValueType.getValueList()) {
                this.values.add(dataKeyType.getStringValue());
                if (!dataKeyType.getCascadeValues()) continue;
                this.caseCadeList.add(dataKeyType.getStringValue());
            }
        }
        if (keyValueType.getTimeRange() != null) {
            this.timeRangeBean = new TimeRangeBeanImpl(keyValueType.getTimeRange(), (SdmxStructureBean)this);
        }
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString(this.id)) {
            throw new ValidationException("KeyValues requires an id");
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean) {
        if (bean.getStructureType() == this.getStructureType()) {
            KeyValues that = (KeyValues)bean;
            if (!ObjectUtil.equivalentCollection(this.values, that.getValues())) {
                return false;
            }
            for (String currentValue : this.values) {
                if (that.isCascadeValue(currentValue) == this.isCascadeValue(currentValue)) continue;
                return false;
            }
            if (!ObjectUtil.equivalent(this.id, that.getId())) {
                return false;
            }
            return super.equivalent(this.timeRangeBean, that.getTimeRange());
        }
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getValues() {
        return new ArrayList<String>(this.values);
    }

    @Override
    public boolean isCascadeValue(String value) {
        return this.caseCadeList.contains(value);
    }

    @Override
    public TimeRangeBean getTimeRange() {
        return this.timeRangeBean;
    }
}

