/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class KeyableImpl
implements Keyable {
    private List<KeyValue> attributes = new ArrayList<KeyValue>();
    private List<KeyValue> key = new ArrayList<KeyValue>();
    private Map<String, KeyValue> attributeMap = new HashMap<String, KeyValue>();
    private Map<String, String> keyMap = new HashMap<String, String>();
    private boolean series;
    private String groupName;
    private TIME_FORMAT timeFormat;
    private String uniqueId;
    private String shotCode;
    private boolean isTimeSeries = true;
    private String crossSectionConcept;
    private String obsTime;
    private Date date;

    public KeyableImpl(List<KeyValue> key, List<KeyValue> attributes, TIME_FORMAT timeFormat, String crossSectionConcept, String obsTime) {
        this(key, attributes, null, timeFormat);
        this.isTimeSeries = false;
        this.crossSectionConcept = crossSectionConcept;
        this.obsTime = obsTime;
        if (obsTime == null) {
            throw new ValidationException("Cross sectional dataset missing time value for key : " + this);
        }
    }

    public KeyableImpl(List<KeyValue> key, List<KeyValue> attributes, TIME_FORMAT timeFormat) {
        this(key, attributes, null, timeFormat);
    }

    public KeyableImpl(List<KeyValue> key, List<KeyValue> attributes, String groupName) {
        this(key, attributes, groupName, null);
    }

    public KeyableImpl(List<KeyValue> key, List<KeyValue> attributes, String groupName, TIME_FORMAT timeFormat) {
        this.series = !ObjectUtil.validString(groupName);
        if (attributes != null) {
            this.attributes = attributes;
            for (KeyValue currentKv : attributes) {
                this.attributeMap.put(currentKv.getConcept(), currentKv);
            }
        }
        if (key != null) {
            this.key = key;
            for (KeyValue currentKv : key) {
                this.keyMap.put(currentKv.getConcept(), currentKv.getCode());
            }
        }
        this.groupName = groupName;
        this.timeFormat = timeFormat;
    }

    @Override
    public String getShortCode() {
        if (this.shotCode == null) {
            this.generateUniqueId();
        }
        return this.shotCode;
    }

    @Override
    public KeyValue getAttribute(String concept) {
        return this.attributeMap.get(concept);
    }

    @Override
    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    @Override
    public String getCrossSectionConcept() {
        return this.crossSectionConcept;
    }

    @Override
    public String getObsTime() {
        return this.obsTime;
    }

    @Override
    public String getKeyValue(String dimensionId) {
        return this.keyMap.get(dimensionId);
    }

    @Override
    public Date getObsAsTimeDate() {
        if (this.isTimeSeries) {
            return null;
        }
        if (this.date == null) {
            this.date = DateUtil.formatDate(this.obsTime, true);
        }
        return new Date(this.date.getTime());
    }

    @Override
    public List<KeyValue> getKey() {
        return new ArrayList<KeyValue>(this.key);
    }

    @Override
    public List<KeyValue> getAttributes() {
        return new ArrayList<KeyValue>(this.attributes);
    }

    @Override
    public boolean isSeries() {
        return this.series;
    }

    @Override
    public TIME_FORMAT getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof KeyableImpl) {
            if (this.uniqueId == null) {
                this.generateUniqueId();
            }
            KeyableImpl that = (KeyableImpl)obj;
            if (that.uniqueId == null) {
                that.generateUniqueId();
            }
            return this.uniqueId.equals(that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        if (this.uniqueId == null) {
            this.generateUniqueId();
        }
        return this.uniqueId.hashCode();
    }

    private void generateUniqueId() {
        this.shotCode = "";
        String concat = "";
        StringBuilder sb = new StringBuilder();
        for (KeyValue kv : this.getKey()) {
            this.shotCode = this.shotCode + concat + kv.getCode();
            concat = ":";
            sb.append(kv.getConcept() + concat + kv.getCode());
        }
        for (KeyValue kv : this.getAttributes()) {
            sb.append(kv.getConcept() + concat + kv.getCode());
        }
        sb.append(this.series);
        if (this.groupName != null) {
            sb.append(this.groupName);
        }
        this.uniqueId = sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.series) {
            sb.append("series ");
        } else {
            sb.append("group " + this.groupName + " ");
        }
        String concat = "";
        for (KeyValue kv : this.key) {
            sb.append(concat);
            sb.append(kv.getConcept());
            sb.append(":");
            sb.append(kv.getCode());
            concat = ",";
        }
        if (!this.isTimeSeries) {
            sb.append(concat);
            sb.append(this.getObsTime());
        }
        return sb.toString();
    }
}

