/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.header;

import java.util.Date;
import javax.xml.stream.XMLStreamReader;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class DatasetHeaderBeanImpl
implements DatasetHeaderBean {
    private MaintainableRefBean dataProviderRef;
    private DatasetStructureReferenceBean datasetStructureReferenceBean;
    private String datasetId;
    private Date reportingBeginDate;
    private Date reportingEndDate;
    private Date validFrom;
    private Date validTo;
    private DATASET_ACTION action = DATASET_ACTION.INFORMATION;
    private int publicationYear = -1;
    private String publicationPeriod;
    private String reportingYearStartDate;

    public DatasetHeaderBeanImpl(String datasetId, DATASET_ACTION action, DatasetStructureReferenceBean datasetStructureReferenceBean) {
        this.datasetId = datasetId;
        if (action != null) {
            this.action = action;
        }
        this.datasetStructureReferenceBean = datasetStructureReferenceBean;
    }

    public DatasetHeaderBeanImpl(String datasetId, DATASET_ACTION action, DatasetStructureReferenceBean datasetStructureReferenceBean, MaintainableRefBean dataProviderRef, Date reportingBeginDate, Date reportingEndDate, Date validFrom, Date validTo, int publicationYear, String publicationPeriod, String reportingYearStartDate) {
        this.dataProviderRef = dataProviderRef;
        this.datasetStructureReferenceBean = datasetStructureReferenceBean;
        this.datasetId = datasetId;
        this.reportingBeginDate = reportingBeginDate;
        this.reportingEndDate = reportingEndDate;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.action = action;
        this.publicationYear = publicationYear;
        this.publicationPeriod = publicationPeriod;
        this.reportingYearStartDate = reportingYearStartDate;
    }

    public DatasetHeaderBeanImpl(XMLStreamReader parser, HeaderBean datasetHeader) {
        if (parser.getAttributeValue(null, "structureRef") != null) {
            String structureRef = parser.getAttributeValue(null, "structureRef");
            this.datasetStructureReferenceBean = this.getStructureFromHeader(datasetHeader, structureRef);
            if (this.datasetStructureReferenceBean == null) {
                throw new ValidationException("Dataset references Structure that is not defined in the Header of the message.  Structure reference defined by Dataset is:" + structureRef);
            }
        } else {
            this.datasetStructureReferenceBean = this.generateOrUseDefaultStructure(parser, datasetHeader);
        }
        if (parser.getAttributeValue(null, "action") != null) {
            this.action = DATASET_ACTION.getAction(parser.getAttributeValue(null, "action"));
        }
        if (parser.getAttributeValue(null, "datasetID") != null) {
            this.datasetId = parser.getAttributeValue(null, "datasetID");
        }
        if (parser.getAttributeValue(null, "publicationPeriod") != null) {
            this.publicationPeriod = parser.getAttributeValue(null, "publicationPeriod");
        }
        if (parser.getAttributeValue(null, "publicationYear") != null) {
            this.publicationYear = Integer.parseInt(parser.getAttributeValue(null, "publicationYear"));
        }
        if (parser.getAttributeValue(null, "reportingBeginDate") != null) {
            this.reportingBeginDate = DateUtil.formatDate(parser.getAttributeValue(null, "reportingBeginDate"), true);
        }
        if (parser.getAttributeValue(null, "reportingEndDate") != null) {
            this.reportingEndDate = DateUtil.formatDate(parser.getAttributeValue(null, "reportingEndDate"), true);
        }
        if (parser.getAttributeValue(null, "validFromDate") != null) {
            this.validFrom = DateUtil.formatDate(parser.getAttributeValue(null, "validFromDate"), true);
        }
        if (parser.getAttributeValue(null, "validToDate") != null) {
            this.validTo = DateUtil.formatDate(parser.getAttributeValue(null, "validToDate"), true);
        }
    }

    @Override
    public DatasetHeaderBean modifyDataStructureReference(DatasetStructureReferenceBean datasetStructureReferenceBean) {
        return new DatasetHeaderBeanImpl(this.getDatasetId(), this.getAction(), datasetStructureReferenceBean, this.getDataProviderReference(), this.getReportingBeginDate(), this.getReportingEndDate(), this.getValidFrom(), this.getValidTo(), this.getPublicationYear(), this.getPublicationPeriod(), null);
    }

    private DatasetStructureReferenceBean generateOrUseDefaultStructure(XMLStreamReader parser, HeaderBean datasetHeader) {
        StructureReferenceBeanImpl sRef = null;
        MaintainableRefBean dataflowReference = this.getDataflowReference(parser);
        MaintainableRefBean dsdReference = this.getDsdReference(parser);
        if (dataflowReference != null) {
            sRef = new StructureReferenceBeanImpl(dataflowReference, SDMX_STRUCTURE_TYPE.DATAFLOW);
        } else if (dsdReference != null) {
            sRef = new StructureReferenceBeanImpl(dsdReference, SDMX_STRUCTURE_TYPE.DSD);
        } else {
            if (datasetHeader.getStructures().size() == 1) {
                return datasetHeader.getStructures().get(0);
            }
            return null;
        }
        return new DatasetStructureReferenceBeanImpl("generated", sRef, null, null, "TIME_PERIOD");
    }

    private DatasetStructureReferenceBean getStructureFromHeader(HeaderBean header, String structureRef) {
        if (header.getStructures() == null) {
            return null;
        }
        for (DatasetStructureReferenceBean currentStructure : header.getStructures()) {
            if (!currentStructure.getId().equals(structureRef)) continue;
            return currentStructure;
        }
        return null;
    }

    private MaintainableRefBean getDataflowReference(XMLStreamReader parser) {
        String dfId = null;
        String dfAcy = null;
        if (parser.getAttributeValue(null, "dataflowAgencyID") != null) {
            dfId = parser.getAttributeValue(null, "dataflowAgencyID");
        }
        if (parser.getAttributeValue(null, "dataflowID") != null) {
            dfAcy = parser.getAttributeValue(null, "dataflowID");
        }
        if (ObjectUtil.validString(dfId)) {
            return new MaintainableRefBeanImpl(dfAcy, dfId, "1.0");
        }
        return null;
    }

    private MaintainableRefBean getDsdReference(XMLStreamReader parser) {
        if (parser.getAttributeValue(null, "keyFamilyURI") != null) {
            String dsdUri = parser.getAttributeValue(null, "keyFamilyURI");
            StructureReferenceBeanImpl dsdRef = new StructureReferenceBeanImpl(dsdUri);
            return dsdRef.getMaintainableReference();
        }
        return null;
    }

    @Override
    public boolean isTimeSeries() {
        if (this.datasetStructureReferenceBean == null) {
            return true;
        }
        return this.datasetStructureReferenceBean.isTimeSeries();
    }

    @Override
    public DatasetStructureReferenceBean getDataStructureReference() {
        return this.datasetStructureReferenceBean;
    }

    @Override
    public DATASET_ACTION getAction() {
        return this.action;
    }

    @Override
    public MaintainableRefBean getDataProviderReference() {
        return this.dataProviderRef;
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public Date getReportingBeginDate() {
        return this.reportingBeginDate;
    }

    @Override
    public Date getReportingEndDate() {
        return this.reportingEndDate;
    }

    @Override
    public Date getValidFrom() {
        return this.validFrom;
    }

    @Override
    public Date getValidTo() {
        return this.validTo;
    }

    @Override
    public int getPublicationYear() {
        return this.publicationYear;
    }

    @Override
    public String getPublicationPeriod() {
        return this.publicationPeriod;
    }
}

