/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReferenceValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.DataKeyBean;
import org.sdmxsource.sdmx.api.model.metadata.ReferenceValueBean;
import org.sdmxsource.sdmx.api.model.metadata.TargetBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.metadata.DataKeyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class ReferenceValueBeanImpl
extends SDMXBeanImpl
implements ReferenceValueBean {
    private static final long serialVersionUID = 2865110943018956204L;
    private String id;
    private String datasetId;
    private CrossReferenceBean identifiableReference;
    private CrossReferenceBean constraintReference;
    private List<DataKeyBean> dataKeys = new ArrayList<DataKeyBean>();
    private Date reportPeriod;

    public ReferenceValueBeanImpl(TargetBean parent, ReferenceValueType type) {
        super(SDMX_STRUCTURE_TYPE.METADATA_REFERENCE_VALUE, (SDMXBean)parent);
        this.id = type.getId();
        if (type.getConstraintContentReference() != null) {
            this.constraintReference = RefUtil.createReference(this, type.getConstraintContentReference());
        }
        if (type.getObjectReference() != null) {
            this.identifiableReference = RefUtil.createReference(this, type.getObjectReference());
        }
        if (type.getDataSetReference() != null) {
            this.datasetId = type.getDataSetReference().getID();
            this.identifiableReference = RefUtil.createReference(this, type.getDataSetReference().getDataProvider());
        }
        if (type.getDataKey() != null) {
            for (ComponentValueSetType cvst : type.getDataKey().getKeyValueList()) {
                this.dataKeys.add(new DataKeyBeanImpl(this, cvst));
            }
        }
        if (type.getReportPeriod() != null) {
            this.reportPeriod = DateUtil.formatDate(type.getReportPeriod(), true);
        }
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString(this.id)) {
            throw new ValidationException("Metadata Report must have an Id");
        }
        if (ObjectUtil.validString(this.datasetId)) {
            if (this.identifiableReference == null) {
                throw new ValidationException("A dataset id was provided without reference to a data provider");
            }
            if (this.dataKeys.size() > 0) {
                throw new ValidationException("Metadata Reference Value can not reference both a data key and a dataset");
            }
        } else if (this.dataKeys.size() > 0) {
            if (this.identifiableReference != null) {
                throw new ValidationException("Metadata Reference Value can not reference both a data key and an identifiable reference");
            }
        } else if (this.reportPeriod == null && this.identifiableReference == null) {
            throw new ValidationException("Metadata Reference Value must refernece either a datakey, dataset, report period, or an identifiable");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public CrossReferenceBean getIdentifiableReference() {
        return this.identifiableReference;
    }

    @Override
    public CrossReferenceBean getContentConstraintReference() {
        return this.constraintReference;
    }

    @Override
    public boolean isDatakeyReference() {
        return this.dataKeys.size() > 0;
    }

    @Override
    public boolean isContentConstriantReference() {
        return this.constraintReference != null;
    }

    @Override
    public List<DataKeyBean> getDataKeys() {
        return new ArrayList<DataKeyBean>(this.dataKeys);
    }

    @Override
    public boolean isDatasetReference() {
        return ObjectUtil.validString(this.datasetId);
    }

    @Override
    public boolean isIdentifiableReference() {
        return !this.isDatasetReference() && this.identifiableReference != null;
    }
}

