/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.ReportedAttributeSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.SuperBeanImpl;

public class ReportedAttributeSuperBeanImpl
extends SuperBeanImpl
implements ReportedAttributeSuperBean {
    private static final long serialVersionUID = -1884960818440120857L;
    private List<ReportedAttributeSuperBean> reportedAttributes = new ArrayList<ReportedAttributeSuperBean>();
    private ReportedAttributeBean builtFrom;
    private ConceptBean concept;
    private CodelistBean codelist;

    public ReportedAttributeSuperBeanImpl(MetadataAttributeBean correspondingMA, ReportedAttributeBean builtFrom, IdentifiableRetrievalManager retrievalManager) {
        super(builtFrom);
        this.builtFrom = builtFrom;
        this.concept = retrievalManager.getIdentifiableBean(correspondingMA.getConceptRef(), ConceptBean.class);
        if (correspondingMA.hasCodedRepresentation()) {
            this.codelist = retrievalManager.getIdentifiableBean(correspondingMA.getRepresentation().getRepresentationRef(), CodelistBean.class);
        }
        if (builtFrom.getReportedAttributes() != null) {
            for (ReportedAttributeBean currentRA : builtFrom.getReportedAttributes()) {
                MetadataAttributeBean maBean = this.getMetadataAttributeForRepotedAttribute(currentRA, correspondingMA.getMetadataAttributes());
                this.reportedAttributes.add(new ReportedAttributeSuperBeanImpl(maBean, currentRA, retrievalManager));
            }
        }
    }

    private MetadataAttributeBean getMetadataAttributeForRepotedAttribute(ReportedAttributeBean reportedAttribute, List<MetadataAttributeBean> mAttributeBeans) {
        for (MetadataAttributeBean currentMAttribute : mAttributeBeans) {
            if (!currentMAttribute.getId().equals(reportedAttribute.getId())) continue;
            return currentMAttribute;
        }
        throw new ReferenceException("Can not find reference to metadata attribute with id " + reportedAttribute.getId());
    }

    @Override
    public ConceptBean getConcept() {
        return this.concept;
    }

    @Override
    public CodelistBean getCodelist() {
        return this.codelist;
    }

    @Override
    public boolean hasCodedRepresentation() {
        return this.codelist != null;
    }

    @Override
    public String getId() {
        return this.builtFrom.getId();
    }

    @Override
    public String getSimpleValue() {
        return this.builtFrom.getSimpleValue();
    }

    @Override
    public List<TextTypeWrapper> getMetadataText() {
        return this.builtFrom.getMetadataText();
    }

    @Override
    public boolean isPresentational() {
        return this.builtFrom.isPresentational();
    }

    @Override
    public boolean hasSimpleValue() {
        return this.builtFrom.hasSimpleValue();
    }

    @Override
    public List<ReportedAttributeSuperBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeSuperBean>(this.reportedAttributes);
    }

    @Override
    public ReportedAttributeBean getBuiltFrom() {
        return this.builtFrom;
    }
}

