/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.query.impl.rest;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.RESTDataQuery;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.data.query.DataQuerySelection;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQueryDimensionSelectionImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQueryImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.query.DataQuerySelectionGroupImpl;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class DataQueryBuilderREST {
    public DataQuery buildDataQuery(RESTDataQuery dataQuery, SdmxBeanRetrievalManager retrievalManager) {
        DataflowBean dataflow = retrievalManager.getDataflow(dataQuery.getFlowRef().getMaintainableReference());
        if (dataflow == null) {
            throw new ValidationException("Data Flow could not be found for query : " + dataQuery.getFlowRef());
        }
        DataStructureBean keyFamily = retrievalManager.getDataStructure(dataflow.getDataStructureRef().getMaintainableReference());
        if (keyFamily == null) {
            throw new ValidationException("DSD could not be found for query : " + dataflow.getDataStructureRef());
        }
        HashSet<DataProviderBean> dataProviders = new HashSet<DataProviderBean>();
        if (dataQuery.getProviderRef() != null) {
            Set<DataProviderSchemeBean> dataProviderSchemes = retrievalManager.getDataProviderSchemeBeans(dataQuery.getProviderRef().getMaintainableReference());
            for (DataProviderSchemeBean currentDpScheme : dataProviderSchemes) {
                for (DataProviderBean dataProvider : currentDpScheme.getItems()) {
                    if (!dataProvider.getId().equals(dataQuery.getProviderRef().getChildReference().getId())) continue;
                    dataProviders.add(dataProvider);
                }
            }
        }
        HashSet<DataQuerySelection> selections = new HashSet<DataQuerySelection>();
        if (dataQuery.getQueryList().size() > 0) {
            int i = 0;
            for (DimensionBean dimension : keyFamily.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION)) {
                if (dataQuery.getQueryList().size() <= i) {
                    throw new ValidationException("Not enough key values in query, expecting " + keyFamily.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION).size() + " got " + dataQuery.getQueryList().size());
                }
                Set<String> queriesForDimension = dataQuery.getQueryList().get(i);
                if (queriesForDimension != null && queriesForDimension.size() > 0) {
                    DataQueryDimensionSelectionImpl selectionsForDimension = new DataQueryDimensionSelectionImpl(ConceptRefUtil.getConceptId(dimension.getConceptRef()), new HashSet<String>(queriesForDimension));
                    selections.add(selectionsForDimension);
                }
                ++i;
            }
        }
        DataQuerySelectionGroupImpl selectionGroup = null;
        if (ObjectUtil.validCollection(selections) || dataQuery.getStartPeriod() != null || dataQuery.getEndPeriod() != null) {
            selectionGroup = new DataQuerySelectionGroupImpl(selections, dataQuery.getStartPeriod(), dataQuery.getEndPeriod());
        }
        return new DataQueryImpl(keyFamily, dataQuery.getUpdatedAfter(), dataQuery.getQueryDetail(), dataQuery.getMaxObs(), dataQuery.isOrderAsc(), dataProviders, dataflow, dataQuery.getDimensionAtObservation(), selectionGroup);
    }
}

