/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl;

import java.util.HashSet;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemeType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowsType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.MaintainableBeanException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategoryBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.CategorisationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.CategorySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataflowBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataflowBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl.AbstractSdmxBeansBuilder;
import org.sdmxsource.util.ObjectUtil;

public abstract class AbstractSdmxBeansV2Builder
extends AbstractSdmxBeansBuilder {
    protected void processCategorySchemes(CategorySchemesType catSchemes, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (catSchemes != null && ObjectUtil.validCollection(catSchemes.getCategorySchemeList())) {
            for (CategorySchemeType currentType : catSchemes.getCategorySchemeList()) {
                try {
                    CategorySchemeBeanImpl csBean = new CategorySchemeBeanImpl(currentType);
                    this.addIfNotDuplicateURN(beans, urns, csBean);
                    if (currentType.getCategoryList() == null) continue;
                    this.processCategory(beans, currentType.getCategoryList(), csBean.getItems());
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    protected void processDataflows(DataflowsType dfType, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (dfType != null && ObjectUtil.validCollection(dfType.getDataflowList())) {
            for (DataflowType currentType : dfType.getDataflowList()) {
                try {
                    DataflowBeanImpl currentDataflow = new DataflowBeanImpl(currentType);
                    this.addIfNotDuplicateURN(beans, urns, currentDataflow);
                    if (currentType.getCategoryRefList() == null) continue;
                    for (CategoryRefType cateogryRefType : currentType.getCategoryRefList()) {
                        beans.addCategorisation(new CategorisationBeanImpl(currentDataflow, cateogryRefType));
                    }
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATAFLOW, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    protected void processMetadataFlows(MetadataflowsType mdfType, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (mdfType != null && ObjectUtil.validCollection(mdfType.getMetadataflowList())) {
            for (MetadataflowType currentType : mdfType.getMetadataflowList()) {
                try {
                    MetadataflowBeanImpl currentMetadataflow = new MetadataflowBeanImpl(currentType);
                    this.addIfNotDuplicateURN(beans, urns, currentMetadataflow);
                    if (currentType.getCategoryRefList() == null) continue;
                    for (CategoryRefType cateogryRefType : currentType.getCategoryRefList()) {
                        beans.addCategorisation(new CategorisationBeanImpl(currentMetadataflow, cateogryRefType));
                    }
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.METADATA_FLOW, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    protected void processCategory(SdmxBeans beans, List<CategoryType> categoryTypes, List<CategoryBean> categoryBeans) {
        if (categoryTypes != null) {
            for (CategoryType cat : categoryTypes) {
                CategoryBean processingCatBean = null;
                for (CategoryBean currentCatBean : categoryBeans) {
                    if (!currentCatBean.getId().equals(cat.getId())) continue;
                    processingCatBean = currentCatBean;
                    break;
                }
                this.processCategory(beans, cat, processingCatBean);
            }
        }
    }

    protected void processCategory(SdmxBeans beans, CategoryType categoryType, CategoryBean categoryBean) {
        this.processCategory(beans, categoryType.getCategoryList(), categoryBean.getItems());
        if (categoryType.getDataflowRefList() != null) {
            for (DataflowRefType dfRef : categoryType.getDataflowRefList()) {
                beans.addCategorisation(new CategorisationBeanImpl(categoryBean, dfRef));
            }
        }
        if (categoryType.getMetadataflowRefList() != null) {
            for (MetadataflowRefType mdfRef : categoryType.getMetadataflowRefList()) {
                beans.addCategorisation(new CategorisationBeanImpl(categoryBean, mdfRef));
            }
        }
    }
}

