/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl;

import java.util.HashSet;
import org.sdmx.resources.sdmxml.schemas.v21.common.ActionType;
import org.sdmx.resources.sdmxml.schemas.v21.message.BaseHeaderType;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AgencySchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.AttachmentConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorisationType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorisationsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorySchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorySchemesType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodelistsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ContentConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataConsumerSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataProviderSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataStructuresType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataflowType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataflowsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodelistType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.HierarchicalCodelistsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataStructureType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataStructuresType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataflowType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataflowsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationSchemesType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationUnitSchemeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessesType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProvisionAgreementType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProvisionAgreementsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportingTaxonomiesType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ReportingTaxonomyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructureSetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructureSetsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructuresType;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.MaintainableBeanException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AgencySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataConsumerSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataProviderSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.OrganisationUnitSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.CategorisationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.CategorySchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.categoryscheme.ReportingTaxonomyBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.HierarchicalCodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme.ConceptSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataflowBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.StructureSetBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataStructureDefinitionBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.metadatastructure.MetadataflowBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ProcessBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.AttachmentConstraintBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ContentConstraintBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ProvisionAgreementBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderImpl;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl.AbstractSdmxBeansBuilder;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class SdmxBeansV21Builder
extends AbstractSdmxBeansBuilder {
    public SdmxBeans build(RegistryInterfaceDocument rid) {
        RegistryInterfaceType rit = rid.getRegistryInterface();
        if (rit.getSubmitStructureRequest() != null && rit.getSubmitStructureRequest().getStructures() != null) {
            DATASET_ACTION action = null;
            if (rit.getSubmitStructureRequest().getAction() != null) {
                if (rit.getSubmitStructureRequest().getAction() == ActionType.APPEND) {
                    action = DATASET_ACTION.APPEND;
                } else if (rit.getSubmitStructureRequest().getAction() == ActionType.REPLACE) {
                    action = DATASET_ACTION.REPLACE;
                } else if (rit.getSubmitStructureRequest().getAction() == ActionType.DELETE) {
                    action = DATASET_ACTION.DELETE;
                }
            }
            return this.build(rit.getSubmitStructureRequest().getStructures(), this.processHeader(rit.getHeader()), action);
        }
        return new SdmxBeansImpl();
    }

    public SdmxBeans build(StructureDocument structuresDoc) {
        StructureType structures = structuresDoc.getStructure();
        if (structures != null && structures.getStructures() != null) {
            return this.build(structures.getStructures(), this.processHeader(structures.getHeader()), null);
        }
        return new SdmxBeansImpl();
    }

    private HeaderBean processHeader(BaseHeaderType baseHeaderType) {
        return new HeaderImpl(baseHeaderType);
    }

    private SdmxBeans build(StructuresType structures, HeaderBean header, DATASET_ACTION action) {
        SdmxBeansImpl beans = new SdmxBeansImpl(header, action);
        this.processOrganisationSchemes(structures.getOrganisationSchemes(), beans);
        this.processDataflows(structures.getDataflows(), beans);
        this.processMetadataFlows(structures.getMetadataflows(), beans);
        this.processCategorySchemes(structures.getCategorySchemes(), beans);
        this.processCategorisations(structures.getCategorisations(), beans);
        this.processCodelists(structures.getCodelists(), beans);
        this.processHierarchicalCodelists(structures.getHierarchicalCodelists(), beans);
        this.processConcepts(structures.getConcepts(), beans);
        this.processMetadataStructures(structures.getMetadataStructures(), beans);
        this.processDataStructures(structures.getDataStructures(), beans);
        this.processStructureSets(structures.getStructureSets(), beans);
        this.processReportingTaxonomies(structures.getReportingTaxonomies(), beans);
        this.processProcesses(structures.getProcesses(), beans);
        this.processConstraints(structures.getConstraints(), beans);
        this.processProvisions(structures.getProvisionAgreements(), beans);
        return beans;
    }

    private void processOrganisationSchemes(OrganisationSchemesType orgSchemesType, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (orgSchemesType != null) {
            if (ObjectUtil.validCollection(orgSchemesType.getAgencySchemeList())) {
                for (AgencySchemeType agencySchemeType : orgSchemesType.getAgencySchemeList()) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new AgencySchemeBeanImpl(agencySchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, agencySchemeType.getAgencyID(), agencySchemeType.getId(), agencySchemeType.getVersion());
                    }
                }
            }
            if (ObjectUtil.validCollection(orgSchemesType.getDataProviderSchemeList())) {
                for (DataProviderSchemeType dataProviderSchemeType : orgSchemesType.getDataProviderSchemeList()) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new DataProviderSchemeBeanImpl(dataProviderSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, dataProviderSchemeType.getAgencyID(), dataProviderSchemeType.getId(), dataProviderSchemeType.getVersion());
                    }
                }
            }
            if (ObjectUtil.validCollection(orgSchemesType.getDataConsumerSchemeList())) {
                for (DataConsumerSchemeType dataConsumerSchemeType : orgSchemesType.getDataConsumerSchemeList()) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new DataConsumerSchemeBeanImpl(dataConsumerSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, dataConsumerSchemeType.getAgencyID(), dataConsumerSchemeType.getId(), dataConsumerSchemeType.getVersion());
                    }
                }
            }
            if (ObjectUtil.validCollection(orgSchemesType.getOrganisationUnitSchemeList())) {
                for (OrganisationUnitSchemeType organisationUnitSchemeType : orgSchemesType.getOrganisationUnitSchemeList()) {
                    try {
                        this.addIfNotDuplicateURN(beans, urns, new OrganisationUnitSchemeBeanImpl(organisationUnitSchemeType));
                    }
                    catch (Throwable th) {
                        throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME, organisationUnitSchemeType.getAgencyID(), organisationUnitSchemeType.getId(), organisationUnitSchemeType.getVersion());
                    }
                }
            }
        }
    }

    private void processDataflows(DataflowsType dfType, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (dfType != null && ObjectUtil.validCollection(dfType.getDataflowList())) {
            for (DataflowType currentType : dfType.getDataflowList()) {
                try {
                    DataflowBeanImpl currentDataflow = new DataflowBeanImpl(currentType);
                    this.addIfNotDuplicateURN(beans, urns, currentDataflow);
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DATAFLOW, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processMetadataFlows(MetadataflowsType mdfType, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (mdfType != null && ObjectUtil.validCollection(mdfType.getMetadataflowList())) {
            for (MetadataflowType currentType : mdfType.getMetadataflowList()) {
                try {
                    MetadataflowBeanImpl currentMetadataflow = new MetadataflowBeanImpl(currentType);
                    this.addIfNotDuplicateURN(beans, urns, currentMetadataflow);
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.METADATA_FLOW, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processCategorySchemes(CategorySchemesType catSchemes, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (catSchemes != null && ObjectUtil.validCollection(catSchemes.getCategorySchemeList())) {
            for (CategorySchemeType currentCatScheme : catSchemes.getCategorySchemeList()) {
                try {
                    CategorySchemeBeanImpl csBean = new CategorySchemeBeanImpl(currentCatScheme);
                    this.addIfNotDuplicateURN(beans, urns, csBean);
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, currentCatScheme.getAgencyID(), currentCatScheme.getId(), currentCatScheme.getVersion());
                }
            }
        }
    }

    private void processCategorisations(CategorisationsType categorisations, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (categorisations != null && ObjectUtil.validCollection(categorisations.getCategorisationList())) {
            for (CategorisationType currentCategorisation : categorisations.getCategorisationList()) {
                try {
                    CategorisationBeanImpl csBean = new CategorisationBeanImpl(currentCategorisation);
                    this.addIfNotDuplicateURN(beans, urns, csBean);
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CATEGORISATION, currentCategorisation.getAgencyID(), currentCategorisation.getId(), currentCategorisation.getVersion());
                }
            }
        }
    }

    private void processCodelists(CodelistsType codelists, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (codelists != null && codelists.getCodelistList() != null) {
            for (CodelistType currentType : codelists.getCodelistList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new CodelistBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CODE_LIST, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processHierarchicalCodelists(HierarchicalCodelistsType hcodelists, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (hcodelists != null && hcodelists.getHierarchicalCodelistList() != null) {
            for (HierarchicalCodelistType currentType : hcodelists.getHierarchicalCodelistList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new HierarchicalCodelistBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processConcepts(ConceptsType concepts, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (concepts != null && concepts.getConceptSchemeList() != null) {
            for (ConceptSchemeType currentType : concepts.getConceptSchemeList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ConceptSchemeBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processMetadataStructures(MetadataStructuresType metadataStructures, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (metadataStructures != null && metadataStructures.getMetadataStructureList() != null) {
            for (MetadataStructureType currentType : metadataStructures.getMetadataStructureList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new MetadataStructureDefinitionBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.MSD, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processDataStructures(DataStructuresType keyfamilies, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (keyfamilies != null && keyfamilies.getDataStructureList() != null) {
            for (DataStructureType currentType : keyfamilies.getDataStructureList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new DataStructureBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DSD, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processStructureSets(StructureSetsType structureSets, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (structureSets != null && structureSets.getStructureSetList() != null) {
            for (StructureSetType currentType : structureSets.getStructureSetList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new StructureSetBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processReportingTaxonomies(ReportingTaxonomiesType reportingTaxonomies, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (reportingTaxonomies != null && reportingTaxonomies.getReportingTaxonomyList() != null) {
            for (ReportingTaxonomyType currentType : reportingTaxonomies.getReportingTaxonomyList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ReportingTaxonomyBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processProcesses(ProcessesType processes, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (processes != null && processes.getProcessList() != null) {
            for (ProcessType currentType : processes.getProcessList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ProcessBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.PROCESS, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }

    private void processConstraints(ConstraintsType constraints, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (constraints != null) {
            for (AttachmentConstraintType attachmentConstraintType : constraints.getAttachmentConstraintList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new AttachmentConstraintBeanImpl(attachmentConstraintType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT, attachmentConstraintType.getAgencyID(), attachmentConstraintType.getId(), attachmentConstraintType.getVersion());
                }
            }
            for (ContentConstraintType contentConstraintType : constraints.getContentConstraintList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ContentConstraintBeanImpl(contentConstraintType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT, contentConstraintType.getAgencyID(), contentConstraintType.getId(), contentConstraintType.getVersion());
                }
            }
        }
    }

    private void processProvisions(ProvisionAgreementsType provisions, SdmxBeans beans) {
        HashSet<String> urns = new HashSet<String>();
        if (provisions != null && ObjectUtil.validCollection(provisions.getProvisionAgreementList())) {
            for (ProvisionAgreementType currentType : provisions.getProvisionAgreementList()) {
                try {
                    this.addIfNotDuplicateURN(beans, urns, new ProvisionAgreementBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT, currentType.getAgencyID(), currentType.getId(), currentType.getVersion());
                }
            }
        }
    }
}

