/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.builder.SuperBeansBuilder;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CategorySchemeSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ConceptSchemeSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DataStructureSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.DataflowSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.HierarchicalCodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ProcessSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ProvisionSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.RegistrationSuperBeanBuilder;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemoryRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SuperBeansBuilderImpl
implements SuperBeansBuilder {
    private static final Logger LOG = Logger.getLogger(SuperBeansBuilderImpl.class);
    @Autowired
    private CategorySchemeSuperBeanBuilder categorySchemeSuperBeanBuilder;
    @Autowired
    private CodelistSuperBeanBuilder codelistSuperBeanBuilder;
    @Autowired
    private ConceptSchemeSuperBeanBuilder conceptSchemeSuperBeanBuilder;
    @Autowired
    private DataflowSuperBeanBuilder dataflowSuperBeanBuilder;
    @Autowired
    private DataStructureSuperBeanBuilder dataStructureSuperBeanBuilder;
    @Autowired
    private HierarchicalCodelistSuperBeanBuilder hierarchicalCodelistSuperBeanBuilder;
    @Autowired
    private ProvisionSuperBeanBuilder provisionSuperBeanBuilder;
    @Autowired
    private ProcessSuperBeanBuilder processSuperBeanBuilder;
    @Autowired
    private RegistrationSuperBeanBuilder registrationSuperBeanBuilder;

    @Override
    public SuperBeans build(SdmxBeans buildFrom) throws BuilderException {
        return this.build(buildFrom, null, new InMemoryRetrievalManager(buildFrom));
    }

    @Override
    public SuperBeans build(SdmxBeans buildFrom, SuperBeans existingBeans, SdmxBeanRetrievalManager retrievalManager) throws BuilderException {
        LOG.debug((Object)"Build Superbeans: Create LocalRetrievalManager");
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        for (CategorySchemeBean categorySchemeBean : buildFrom.getCategorySchemes()) {
            LOG.debug((Object)("Build SuperBean: " + categorySchemeBean.getUrn()));
            existingBeans.addCategoryScheme(this.categorySchemeSuperBeanBuilder.build(categorySchemeBean));
        }
        for (CodelistBean codelistBean : buildFrom.getCodelists()) {
            LOG.debug((Object)("Build SuperBean: " + codelistBean.getUrn()));
            existingBeans.addCodelist(this.codelistSuperBeanBuilder.build(codelistBean));
        }
        for (ConceptSchemeBean conceptSchemeBean : buildFrom.getConceptSchemes()) {
            LOG.debug((Object)("Build SuperBean: " + conceptSchemeBean.getUrn()));
            existingBeans.addConceptScheme(this.conceptSchemeSuperBeanBuilder.build(conceptSchemeBean, retrievalManager, existingBeans));
        }
        for (DataflowBean dataflowBean : buildFrom.getDataflows()) {
            LOG.debug((Object)("Build SuperBean: " + dataflowBean.getUrn()));
            existingBeans.addDataflow(this.dataflowSuperBeanBuilder.build(dataflowBean, retrievalManager, existingBeans));
        }
        for (DataStructureBean dataStructureBean : buildFrom.getDataStructures()) {
            LOG.debug((Object)("Build SuperBean: " + dataStructureBean.getUrn()));
            existingBeans.addDataStructure(this.dataStructureSuperBeanBuilder.build(dataStructureBean, retrievalManager, existingBeans));
        }
        for (HierarchicalCodelistBean hierarchicalCodelistBean : buildFrom.getHierarchicalCodelists()) {
            LOG.debug((Object)("Build SuperBean: " + hierarchicalCodelistBean.getUrn()));
            existingBeans.addHierarchicalCodelist(this.hierarchicalCodelistSuperBeanBuilder.build(hierarchicalCodelistBean, retrievalManager));
        }
        for (ProvisionAgreementBean provisionAgreementBean : buildFrom.getProvisionAgreements()) {
            LOG.debug((Object)("Build SuperBean: " + provisionAgreementBean.getUrn()));
            existingBeans.addProvision(this.provisionSuperBeanBuilder.build(provisionAgreementBean, retrievalManager, existingBeans));
        }
        for (ProcessBean processBean : buildFrom.getProcesses()) {
            LOG.debug((Object)("Build SuperBean: " + processBean.getUrn()));
            existingBeans.addProcess(this.processSuperBeanBuilder.build(processBean, retrievalManager));
        }
        for (RegistrationBean registrationBean : buildFrom.getRegistrations()) {
            LOG.debug((Object)("Build SuperBean: " + registrationBean.getUrn()));
            existingBeans.addRegistration(this.registrationSuperBeanBuilder.build(registrationBean, retrievalManager, existingBeans));
        }
        return existingBeans;
    }
}

