/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl;

import org.apache.xmlbeans.XmlObject;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_ERROR_CODE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.QueryStructureResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.QueryStructureResponseBuilderV2;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21.ErrorResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.StructureXmlBeanBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryStructureResponseBuilderImpl
implements QueryStructureResponseBuilder {
    @Autowired
    private QueryStructureResponseBuilderV2 v2Builder;
    @Autowired
    private org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureXmlBeanBuilder structv2Builder;
    @Autowired
    private StructureXmlBeanBuilder structv1Builder;
    @Autowired
    private org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.StructureXmlBeanBuilder structV2_1Builder;
    @Autowired
    private ErrorResponseBuilder errorResponseBuilder2_1;

    @Override
    public XmlObject buildErrorResponse(Throwable th, SDMX_SCHEMA schemaVersion) {
        switch (schemaVersion) {
            case VERSION_TWO_POINT_ONE: {
                return this.errorResponseBuilder2_1.buildErrorResponse(th);
            }
            case VERSION_TWO: {
                return this.v2Builder.buildErrorResponse(th);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
    }

    @Override
    public XmlObject buildSuccessResponse(SdmxBeans beans, SDMX_SCHEMA schemaVersion, boolean returnAsStructureMessage) {
        switch (schemaVersion) {
            case VERSION_TWO_POINT_ONE: {
                if (beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size() == 0) {
                    return this.errorResponseBuilder2_1.buildErrorResponse(SDMX_ERROR_CODE.NO_RESULTS_FOUND);
                }
                return this.structV2_1Builder.build(beans);
            }
            case VERSION_TWO: {
                if (returnAsStructureMessage) {
                    return this.structv2Builder.build(beans);
                }
                return this.v2Builder.buildSuccessResponse(beans);
            }
            case VERSION_ONE: {
                return this.structv1Builder.build(beans);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
    }
}

