/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import java.util.HashSet;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryStructureResponseType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeListsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.DataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamiliesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureDefinitionsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataflowsType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ReportingTaxonomiesType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetsType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BaseUncheckedException;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CategorySchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ConceptSchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DataStructureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.DataflowXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.HierarchicalCodelistXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.MetadataStructureDefinitionXmlBeansBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.MetadataflowXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.OrganisationSchemeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ProcessXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.ReportingTaxonomyXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureHeaderXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureSetXmlBeanBuilder;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryStructureResponseBuilderV2
extends AbstractResponseBuilder {
    @Autowired
    private StructureHeaderXmlBeanBuilder headerXmlBeansBuilder;
    @Autowired
    private CategorySchemeXmlBeanBuilder categorySchemeXmlBeanBuilder;
    @Autowired
    private CodelistXmlBeanBuilder codelistXmlBeanBuilder;
    @Autowired
    private ConceptSchemeXmlBeanBuilder conceptSchemeXmlBeanBuilder;
    @Autowired
    private DataflowXmlBeanBuilder dataflowXmlBeanBuilder;
    @Autowired
    private HierarchicalCodelistXmlBeanBuilder hierarchicalCodelistXmlBeanBuilder;
    @Autowired
    private DataStructureXmlBeanBuilder dataStructureXmlBeanBuilder;
    @Autowired
    private MetadataflowXmlBeanBuilder metadataflowXmlBeanBuilder;
    @Autowired
    private MetadataStructureDefinitionXmlBeansBuilder metadataStructureDefinitionXmlBeansBuilder;
    @Autowired
    private OrganisationSchemeXmlBeanBuilder organisationSchemeXmlBeanBuilder;
    @Autowired
    private ProcessXmlBeanBuilder processXmlBeanBuilder;
    @Autowired
    private ReportingTaxonomyXmlBeanBuilder reportingTaxonomyXmlBeanBuilder;
    @Autowired
    private StructureSetXmlBeanBuilder structureSetXmlBeanBuilder;

    public RegistryInterfaceDocument buildErrorResponse(Throwable th) throws BuilderException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryStructureResponseType returnType = regInterface.addNewQueryStructureResponse();
        V2Helper.setHeader(regInterface);
        StatusMessageType statusMessage = returnType.addNewStatusMessage();
        statusMessage.setStatus(StatusType.FAILURE);
        TextType tt = statusMessage.addNewMessageText();
        if (th instanceof BaseUncheckedException) {
            tt.setStringValue(((BaseUncheckedException)th).getFullMessage());
        } else {
            tt.setStringValue(th.getMessage());
        }
        return responseType;
    }

    public RegistryInterfaceDocument buildSuccessResponse(SdmxBeans beans) throws BuilderException {
        return this.buildSuccessResponse(beans, null);
    }

    public RegistryInterfaceDocument buildSuccessResponse(SdmxBeans beans, String warningMessage) throws BuilderException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryStructureResponseType returnType = regInterface.addNewQueryStructureResponse();
        HeaderType headerType = null;
        if (beans.getHeader() != null) {
            headerType = this.headerXmlBeansBuilder.build(beans.getHeader());
            regInterface.setHeader(headerType);
        } else {
            headerType = regInterface.addNewHeader();
            V2Helper.setHeader(headerType, beans);
        }
        StatusMessageType statusMessage = returnType.addNewStatusMessage();
        if (ObjectUtil.validString(warningMessage) || !ObjectUtil.validCollection(beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]))) {
            statusMessage.setStatus(StatusType.WARNING);
            TextType tt = statusMessage.addNewMessageText();
            if (ObjectUtil.validString(warningMessage)) {
                tt.setStringValue(warningMessage);
            } else {
                tt.setStringValue("No Structures Match The Query Parameters");
            }
        } else {
            statusMessage.setStatus(StatusType.SUCCESS);
        }
        Set<CategorisationBean> categorisations = beans.getCategorisations();
        if (beans.getCategorySchemes().size() > 0) {
            CategorySchemesType catSchemesType = returnType.addNewCategorySchemes();
            for (CategorySchemeBean categorySchemeBean : beans.getCategorySchemes()) {
                HashSet<CategorisationBean> matchingCategorisations = new HashSet<CategorisationBean>();
                for (CategorisationBean cat : categorisations) {
                    if (!MaintainableUtil.match(categorySchemeBean, cat.getCategoryReference())) continue;
                    matchingCategorisations.add(cat);
                }
                catSchemesType.getCategorySchemeList().add(this.categorySchemeXmlBeanBuilder.build(categorySchemeBean, categorisations));
            }
        }
        if (beans.getCodelists().size() > 0) {
            CodeListsType codeListsType = returnType.addNewCodeLists();
            for (CodelistBean codelistBean : beans.getCodelists()) {
                codeListsType.getCodeListList().add(this.codelistXmlBeanBuilder.build(codelistBean));
            }
        }
        if (beans.getConceptSchemes().size() > 0) {
            ConceptsType conceptsType = returnType.addNewConcepts();
            for (ConceptSchemeBean conceptSchemeBean : beans.getConceptSchemes()) {
                conceptsType.getConceptSchemeList().add(this.conceptSchemeXmlBeanBuilder.build(conceptSchemeBean));
            }
        }
        if (beans.getDataflows().size() > 0) {
            DataflowsType dataflowsType = returnType.addNewDataflows();
            for (DataflowBean dataflowBean : beans.getDataflows()) {
                dataflowsType.getDataflowList().add(this.dataflowXmlBeanBuilder.build(dataflowBean, this.getCategorisations(dataflowBean, categorisations)));
            }
        }
        if (beans.getHierarchicalCodelists().size() > 0) {
            HierarchicalCodelistsType hierarchicalCodelistsType = returnType.addNewHierarchicalCodelists();
            for (HierarchicalCodelistBean hierarchicalCodelistBean : beans.getHierarchicalCodelists()) {
                hierarchicalCodelistsType.getHierarchicalCodelistList().add(this.hierarchicalCodelistXmlBeanBuilder.build(hierarchicalCodelistBean));
            }
        }
        if (beans.getDataStructures().size() > 0) {
            KeyFamiliesType keyFamiliesType = returnType.addNewKeyFamilies();
            for (DataStructureBean dataStructureBean : beans.getDataStructures()) {
                keyFamiliesType.getKeyFamilyList().add(this.dataStructureXmlBeanBuilder.build(dataStructureBean));
            }
        }
        if (beans.getMetadataflows().size() > 0) {
            MetadataflowsType metadataflowsType = returnType.addNewMetadataflows();
            for (MetadataFlowBean metadataFlowBean : beans.getMetadataflows()) {
                metadataflowsType.getMetadataflowList().add(this.metadataflowXmlBeanBuilder.build(metadataFlowBean, this.getCategorisations(metadataFlowBean, categorisations)));
            }
        }
        if (beans.getMetadataStructures().size() > 0) {
            MetadataStructureDefinitionsType msdsType = returnType.addNewMetadataStructureDefinitions();
            for (MetadataStructureDefinitionBean metadataStructureDefinitionBean : beans.getMetadataStructures()) {
                msdsType.getMetadataStructureDefinitionList().add(this.metadataStructureDefinitionXmlBeansBuilder.build(metadataStructureDefinitionBean));
            }
        }
        OrganisationSchemesType orgSchemesType = null;
        if (beans.getAgenciesSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (AgencySchemeBean agencySchemeBean : beans.getAgenciesSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build(agencySchemeBean));
            }
        }
        if (beans.getDataConsumerSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataConsumerSchemeBean dataConsumerSchemeBean : beans.getDataConsumerSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build(dataConsumerSchemeBean));
            }
        }
        if (beans.getDataProviderSchemes().size() > 0) {
            if (orgSchemesType == null) {
                orgSchemesType = returnType.addNewOrganisationSchemes();
            }
            for (DataProviderSchemeBean dataProviderSchemeBean : beans.getDataProviderSchemes()) {
                orgSchemesType.getOrganisationSchemeList().add(this.organisationSchemeXmlBeanBuilder.build(dataProviderSchemeBean));
            }
        }
        if (beans.getProcesses().size() > 0) {
            ProcessesType processesType = returnType.addNewProcesses();
            for (ProcessBean processBean : beans.getProcesses()) {
                processesType.getProcessList().add(this.processXmlBeanBuilder.build(processBean));
            }
        }
        if (beans.getStructureSets().size() > 0) {
            StructureSetsType structureSetsType = returnType.addNewStructureSets();
            for (StructureSetBean structureSetBean : beans.getStructureSets()) {
                structureSetsType.getStructureSetList().add(this.structureSetXmlBeanBuilder.build(structureSetBean));
            }
        }
        if (beans.getReportingTaxonomys().size() > 0) {
            ReportingTaxonomiesType reportingTaxonomiesType = returnType.addNewReportingTaxonomies();
            for (ReportingTaxonomyBean reportingTaxonomyBean : beans.getReportingTaxonomys()) {
                reportingTaxonomiesType.getReportingTaxonomyList().add(this.reportingTaxonomyXmlBeanBuilder.build(reportingTaxonomyBean));
            }
        }
        if (beans.getAttachmentConstraints().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Attachment Constraint at SMDX v2.0 - please use SDMX v2.1");
        }
        if (beans.getContentConstraintBeans().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Content Constraint at SMDX v2.0 - please use SDMX v2.1");
        }
        if (beans.getMetadataStructures().size() > 0) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "Metadata Structure Definition at SMDX v2.0 - please use SDMX v2.1");
        }
        return responseType;
    }

    private Set<CategorisationBean> getCategorisations(MaintainableBean maint, Set<CategorisationBean> categorisations) {
        HashSet<CategorisationBean> returnSet = new HashSet<CategorisationBean>();
        for (CategorisationBean cat : categorisations) {
            if (cat.getStructureReference().getTargetReference() != maint.getStructureType() || !MaintainableUtil.match(maint, cat.getStructureReference())) continue;
            returnSet.add(cat);
        }
        return returnSet;
    }
}

