/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21;

import org.sdmx.resources.sdmxml.schemas.v21.common.CodedStatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ErrorDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ErrorType;
import org.sdmxsource.sdmx.api.constants.SDMX_ERROR_CODE;
import org.sdmxsource.sdmx.api.exception.BaseUncheckedException;
import org.springframework.stereotype.Service;

@Service
public class ErrorResponseBuilder {
    public ErrorDocument buildErrorResponse(Throwable th) {
        ErrorDocument errorDoc = ErrorDocument.Factory.newInstance();
        ErrorType error = errorDoc.addNewError();
        CodedStatusMessageType errorMessage = error.addNewErrorMessage();
        errorMessage.setCode("1000");
        TextType text = errorMessage.addNewText();
        if (th instanceof BaseUncheckedException) {
            text.setStringValue(((BaseUncheckedException)th).getFullMessage());
        } else {
            text.setStringValue(th.getMessage());
        }
        return errorDoc;
    }

    public ErrorDocument buildErrorResponse(SDMX_ERROR_CODE errorCode) {
        ErrorDocument errorDoc = ErrorDocument.Factory.newInstance();
        ErrorType error = errorDoc.addNewError();
        CodedStatusMessageType errorMessage = error.addNewErrorMessage();
        errorMessage.setCode(errorCode.getClientErrorCode().toString());
        TextType text = errorMessage.addNewText();
        text.setStringValue(errorCode.getErrorString());
        return errorDoc;
    }
}

