/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1;

import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ComponentsType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.KeyFamilyType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.AbstractBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.AttributeXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.DimensionXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.GroupXmlBeansBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.PrimaryMeasureXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.TimeDimensionXmlBeanBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dataStructureXmlBeanBuilderV1")
public class DataStructureXmlBeanBuilder
extends AbstractBuilder
implements Builder<KeyFamilyType, DataStructureBean> {
    @Autowired
    private DimensionXmlBeanBuilder dimensionXmlBeanBuilder;
    @Autowired
    private TimeDimensionXmlBeanBuilder timeDimensionXmlBeanBuilder;
    @Autowired
    private GroupXmlBeansBuilder groupXmlBeansBuilder;
    @Autowired
    private PrimaryMeasureXmlBeanBuilder primaryMeasureXmlBeanBuilder;
    @Autowired
    private AttributeXmlBeanBuilder attributeXmlBeanBuilder;

    static {
        AbstractBuilder.log = Logger.getLogger(DataStructureXmlBeanBuilder.class);
    }

    @Override
    public KeyFamilyType build(DataStructureBean buildFrom) throws BuilderException {
        KeyFamilyType builtObj = KeyFamilyType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgency(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        ComponentsType componentsType = builtObj.addNewComponents();
        if (ObjectUtil.validCollection(buildFrom.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION))) {
            for (DimensionBean currentDim : buildFrom.getDimensions(SDMX_STRUCTURE_TYPE.DIMENSION, SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION)) {
                componentsType.getDimensionList().add(this.dimensionXmlBeanBuilder.build(currentDim));
            }
        }
        if (buildFrom.getTimeDimension() != null) {
            componentsType.setTimeDimension(this.timeDimensionXmlBeanBuilder.build(buildFrom.getTimeDimension()));
        }
        if (ObjectUtil.validCollection(buildFrom.getGroups())) {
            for (GroupBean currentGroup : buildFrom.getGroups()) {
                componentsType.getGroupList().add(this.groupXmlBeansBuilder.build(currentGroup));
            }
        }
        if (buildFrom.getPrimaryMeasure() != null) {
            componentsType.setPrimaryMeasure(this.primaryMeasureXmlBeanBuilder.build(buildFrom.getPrimaryMeasure()));
        }
        if (ObjectUtil.validCollection(buildFrom.getAttributes())) {
            for (AttributeBean currentAttr : buildFrom.getAttributes()) {
                componentsType.getAttributeList().add(this.attributeXmlBeanBuilder.build(currentAttr));
            }
        }
        return builtObj;
    }
}

