/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistRefBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchyBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.CodelistRefXmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.HierarchyXmlBeanBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="HierarchicalCodelistXmlBeanBuilderV2")
public class HierarchicalCodelistXmlBeanBuilder
extends AbstractBuilder
implements Builder<HierarchicalCodelistType, HierarchicalCodelistBean> {
    @Autowired
    private HierarchyXmlBeanBuilder hierarchyXmlBeanBuilder;
    @Autowired
    private CodelistRefXmlBeanBuilder codelistRefXmlBeanBuilder;

    @Override
    public HierarchicalCodelistType build(HierarchicalCodelistBean buildFrom) throws BuilderException {
        HierarchicalCodelistType builtObj = HierarchicalCodelistType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgencyID(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (buildFrom.getStartDate() != null) {
            builtObj.setValidFrom(buildFrom.getStartDate().getDate());
        }
        if (buildFrom.getEndDate() != null) {
            builtObj.setValidTo(buildFrom.getEndDate().getDate());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (buildFrom.isExternalReference().isSet()) {
            builtObj.setIsExternalReference(buildFrom.isExternalReference().isTrue());
        }
        if (buildFrom.isFinal().isSet()) {
            builtObj.setIsFinal(buildFrom.isFinal().isTrue());
        }
        if (ObjectUtil.validCollection(buildFrom.getHierarchies())) {
            for (HierarchyBean hierarchyBean : buildFrom.getHierarchies()) {
                builtObj.getHierarchyList().add(this.hierarchyXmlBeanBuilder.build(hierarchyBean));
            }
        }
        if (ObjectUtil.validCollection(buildFrom.getCodelistRef())) {
            for (CodelistRefBean codelistRefBean : buildFrom.getCodelistRef()) {
                builtObj.getCodelistRefList().add(this.codelistRefXmlBeanBuilder.build(codelistRefBean));
            }
        }
        return builtObj;
    }
}

