/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryIDType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemeMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodelistMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.RelatedStructuresType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureMapType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ToValueTypeType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.mapping.CategoryMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.CategorySchemeMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.CodelistMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ComponentMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ConceptSchemeMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ItemMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.OrganisationSchemeMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RelatedStructuresBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.springframework.stereotype.Service;

@Service(value="StructureSetXmlBeanBuilderV2")
public class StructureSetXmlBeanBuilder
extends AbstractBuilder {
    public StructureSetType build(StructureSetBean buildFrom) throws BuilderException {
        StructureSetType builtObj = StructureSetType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgencyID(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (buildFrom.getStartDate() != null) {
            builtObj.setValidFrom(buildFrom.getStartDate().getDate());
        }
        if (buildFrom.getEndDate() != null) {
            builtObj.setValidTo(buildFrom.getEndDate().getDate());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations(buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType(buildFrom));
        }
        if (buildFrom.isExternalReference().isSet()) {
            builtObj.setIsExternalReference(buildFrom.isExternalReference().isTrue());
        }
        if (buildFrom.isFinal().isSet()) {
            builtObj.setIsFinal(buildFrom.isFinal().isTrue());
        }
        this.processRelatedStructures(builtObj, buildFrom);
        if (buildFrom.getStructureMapList() != null) {
            for (StructureMapBean structureMapBean : buildFrom.getStructureMapList()) {
                this.processStructureMap(builtObj, structureMapBean);
            }
        }
        if (buildFrom.getCodelistMapList() != null) {
            for (CodelistMapBean codelistMapBean : buildFrom.getCodelistMapList()) {
                this.processCodelistMap(builtObj, codelistMapBean);
            }
        }
        if (buildFrom.getCategorySchemeMapList() != null) {
            for (CategorySchemeMapBean categorySchemeMapBean : buildFrom.getCategorySchemeMapList()) {
                this.processCategorySchemeMap(builtObj, categorySchemeMapBean);
            }
        }
        if (buildFrom.getConceptSchemeMapList() != null) {
            for (ConceptSchemeMapBean conceptSchemeMapBean : buildFrom.getConceptSchemeMapList()) {
                this.processConceptSchemeMap(builtObj, conceptSchemeMapBean);
            }
        }
        if (buildFrom.getOrganisationSchemeMapList() != null) {
            for (OrganisationSchemeMapBean organisationSchemeMapBean : buildFrom.getOrganisationSchemeMapList()) {
                this.processOrganisationSchemeMap(builtObj, organisationSchemeMapBean);
            }
        }
        return builtObj;
    }

    private void processRelatedStructures(StructureSetType structureSetType, StructureSetBean buildFrom) {
        if (buildFrom.getRelatedStructures() != null) {
            Object refType;
            RelatedStructuresType relatedStructuresType = structureSetType.addNewRelatedStructures();
            RelatedStructuresBean relatedStructures = buildFrom.getRelatedStructures();
            for (CrossReferenceBean ref : relatedStructures.getDataStructureRef()) {
                KeyFamilyRefType kfRefType = relatedStructuresType.addNewKeyFamilyRef();
                this.setDataStructureRefAttributes(kfRefType, ref);
            }
            for (CrossReferenceBean ref : relatedStructures.getMetadataStructureRef()) {
                refType = relatedStructuresType.addNewMetadataStructureRef();
                this.setMetadataStructureRefAttributes((MetadataStructureRefType)refType, ref);
            }
            for (CrossReferenceBean ref : relatedStructures.getConceptSchemeRef()) {
                refType = relatedStructuresType.addNewConceptSchemeRef();
                this.setConceptSchemeRefAttributes((ConceptSchemeRefType)refType, ref);
            }
            for (CrossReferenceBean ref : relatedStructures.getCategorySchemeRef()) {
                refType = relatedStructuresType.addNewCategorySchemeRef();
                this.setCategorySchemeRefAttributes((CategorySchemeRefType)refType, ref);
            }
            for (CrossReferenceBean ref : relatedStructures.getOrgSchemeRef()) {
                refType = relatedStructuresType.addNewOrganisationSchemeRef();
                this.setOrganisationSchemeRefAttributes((OrganisationSchemeRefType)refType, ref);
            }
            for (CrossReferenceBean ref : relatedStructures.getHierCodelistRef()) {
                refType = relatedStructuresType.addNewHierarchicalCodelistRef();
                this.setHclRefAttributes((HierarchicalCodelistRefType)refType, ref);
            }
        }
    }

    private void processStructureMap(StructureSetType structureSetType, StructureMapBean buildFrom) {
        MetadataStructureRefType refType;
        KeyFamilyRefType kfRefType;
        StructureMapType structureMapType = structureSetType.addNewStructureMap();
        structureMapType.setIsExtension(buildFrom.isExtension());
        if (this.validString(buildFrom.getId())) {
            structureMapType.setId(buildFrom.getId());
        }
        if (this.validCollection(buildFrom.getNames())) {
            structureMapType.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            structureMapType.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (buildFrom.getSourceRef() != null) {
            if (buildFrom.getSourceRef().getTargetReference() == SDMX_STRUCTURE_TYPE.DSD) {
                kfRefType = structureMapType.addNewKeyFamilyRef();
                this.setDataStructureRefAttributes(kfRefType, buildFrom.getSourceRef());
            } else if (buildFrom.getSourceRef().getTargetReference() == SDMX_STRUCTURE_TYPE.MSD) {
                refType = structureMapType.addNewMetadataStructureRef();
                this.setMetadataStructureRefAttributes(refType, buildFrom.getSourceRef());
            }
        }
        if (buildFrom.getTargetRef() != null) {
            if (buildFrom.getTargetRef().getTargetReference() == SDMX_STRUCTURE_TYPE.DSD) {
                kfRefType = structureMapType.addNewTargetKeyFamilyRef();
                this.setDataStructureRefAttributes(kfRefType, buildFrom.getTargetRef());
            } else if (buildFrom.getTargetRef().getTargetReference() == SDMX_STRUCTURE_TYPE.MSD) {
                refType = structureMapType.addNewTargetMetadataStructureRef();
                this.setMetadataStructureRefAttributes(refType, buildFrom.getTargetRef());
            }
        }
        if (this.validCollection(buildFrom.getComponents())) {
            for (ComponentMapBean componentMapBean : buildFrom.getComponents()) {
                ComponentMapType componentMapType = structureMapType.addNewComponentMap();
                this.processComponent(componentMapType, componentMapBean);
            }
        }
        if (this.hasAnnotations(buildFrom)) {
            structureMapType.setAnnotations(this.getAnnotationsType(buildFrom));
        }
    }

    private void processComponent(ComponentMapType componentMapType, ComponentMapBean componentMapBean) {
        if (componentMapBean.getMapConceptRef() != null) {
            componentMapType.setMapConceptRef(componentMapBean.getMapConceptRef());
        }
        if (componentMapBean.getMapTargetConceptRef() != null) {
            componentMapType.setMapTargetConceptRef(componentMapBean.getMapTargetConceptRef());
        }
        if (componentMapBean.getRepMapRef() != null) {
            if (componentMapBean.getRepMapRef().getToTextFormat() != null) {
                TextFormatType textForamtType = TextFormatType.Factory.newInstance();
                componentMapType.setToTextFormat(textForamtType);
                super.populateTextFormatType(textForamtType, componentMapBean.getRepMapRef().getToTextFormat());
            }
            if (componentMapBean.getRepMapRef().getToValueType() != null) {
                switch (componentMapBean.getRepMapRef().getToValueType()) {
                    case DESCRIPTION: {
                        componentMapType.setToValueType(ToValueTypeType.DESCRIPTION);
                        break;
                    }
                    case NAME: {
                        componentMapType.setToValueType(ToValueTypeType.NAME);
                        break;
                    }
                    case VALUE: {
                        componentMapType.setToValueType(ToValueTypeType.VALUE);
                    }
                }
            }
        }
    }

    private void processCodelistMap(StructureSetType structureSetType, CodelistMapBean buildFrom) {
        Object refType;
        CodelistMapType codelistMap = structureSetType.addNewCodelistMap();
        if (this.validString(buildFrom.getId())) {
            codelistMap.setId(buildFrom.getId());
        }
        if (this.validCollection(buildFrom.getNames())) {
            codelistMap.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            codelistMap.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (buildFrom.getSourceRef() != null) {
            if (buildFrom.getSourceRef().getTargetReference() == SDMX_STRUCTURE_TYPE.CODE_LIST) {
                refType = codelistMap.addNewCodelistRef();
                this.setCodelistRefAttributes((CodelistRefType)refType, buildFrom.getSourceRef());
            } else if (buildFrom.getSourceRef().getTargetReference() == SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST) {
                refType = codelistMap.addNewHierarchicalCodelistRef();
                this.setHclRefAttributes((HierarchicalCodelistRefType)refType, buildFrom.getSourceRef());
            }
        }
        if (buildFrom.getTargetRef() != null) {
            if (buildFrom.getTargetRef().getTargetReference() == SDMX_STRUCTURE_TYPE.CODE_LIST) {
                refType = codelistMap.addNewTargetCodelistRef();
                this.setCodelistRefAttributes((CodelistRefType)refType, buildFrom.getTargetRef());
            } else if (buildFrom.getTargetRef().getTargetReference() == SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST) {
                refType = codelistMap.addNewTargetHierarchicalCodelistRef();
                this.setHclRefAttributes((HierarchicalCodelistRefType)refType, buildFrom.getTargetRef());
            }
        }
        if (this.validCollection(buildFrom.getItems())) {
            for (ItemMapBean itemMapBean : buildFrom.getItems()) {
                CodeMapType codeMaptype = codelistMap.addNewCodeMap();
                if (this.validString(itemMapBean.getSourceId())) {
                    codeMaptype.setMapCodeRef(itemMapBean.getSourceId());
                }
                if (!this.validString(itemMapBean.getTargetId())) continue;
                codeMaptype.setMapTargetCodeRef(itemMapBean.getTargetId());
            }
        }
        if (this.hasAnnotations(buildFrom)) {
            codelistMap.setAnnotations(this.getAnnotationsType(buildFrom));
        }
    }

    private void processCategorySchemeMap(StructureSetType structureSetType, CategorySchemeMapBean buildFrom) {
        CategorySchemeRefType catRefType;
        CategorySchemeMapType catSchemeMap = structureSetType.addNewCategorySchemeMap();
        if (this.validString(buildFrom.getId())) {
            catSchemeMap.setId(buildFrom.getId());
        }
        if (this.validCollection(buildFrom.getNames())) {
            catSchemeMap.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            catSchemeMap.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (buildFrom.getSourceRef() != null) {
            catRefType = catSchemeMap.addNewCategorySchemeRef();
            this.setCategorySchemeRefAttributes(catRefType, buildFrom.getSourceRef());
        }
        if (buildFrom.getTargetRef() != null) {
            catRefType = catSchemeMap.addNewTargetCategorySchemeRef();
            this.setCategorySchemeRefAttributes(catRefType, buildFrom.getTargetRef());
        }
        if (this.validCollection(buildFrom.getCategoryMaps())) {
            for (CategoryMapBean categoryMapBean : buildFrom.getCategoryMaps()) {
                CategoryIDType categoryIdType;
                CategoryMapType categoryMapType = catSchemeMap.addNewCategoryMap();
                if (this.validString(categoryMapBean.getAlias())) {
                    categoryMapType.setCategoryAlias(categoryMapBean.getAlias());
                }
                if (categoryMapBean.getSourceId() != null) {
                    categoryIdType = categoryMapType.addNewCategoryID();
                    this.setCategoryIdAttributes(categoryIdType, categoryMapBean.getSourceId(), 0);
                }
                if (categoryMapBean.getTargetId() == null) continue;
                categoryIdType = categoryMapType.addNewTargetCategoryID();
                this.setCategoryIdAttributes(categoryIdType, categoryMapBean.getTargetId(), 0);
            }
        }
        if (this.hasAnnotations(buildFrom)) {
            catSchemeMap.setAnnotations(this.getAnnotationsType(buildFrom));
        }
    }

    private void setCategoryIdAttributes(CategoryIDType categoryIdType, List<String> categoryIds, int currentPos) {
        if (categoryIds != null && categoryIds.size() > currentPos) {
            categoryIdType.setID(categoryIds.get(currentPos));
        }
        int nextPos = currentPos++;
        if (categoryIds.size() > nextPos) {
            CategoryIDType subType = categoryIdType.addNewCategoryID();
            this.setCategoryIdAttributes(subType, categoryIds, nextPos);
        }
    }

    private void processConceptSchemeMap(StructureSetType structureSetType, ConceptSchemeMapBean buildFrom) {
        ConceptSchemeRefType refType;
        ConceptSchemeMapType conceptSchemeMap = structureSetType.addNewConceptSchemeMap();
        if (this.validString(buildFrom.getId())) {
            conceptSchemeMap.setId(buildFrom.getId());
        }
        if (this.validCollection(buildFrom.getNames())) {
            conceptSchemeMap.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            conceptSchemeMap.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (buildFrom.getSourceRef() != null) {
            refType = conceptSchemeMap.addNewConceptSchemeRef();
            this.setConceptSchemeRefAttributes(refType, buildFrom.getSourceRef());
        }
        if (buildFrom.getTargetRef() != null) {
            refType = conceptSchemeMap.addNewTargetConceptSchemeRef();
            this.setConceptSchemeRefAttributes(refType, buildFrom.getTargetRef());
        }
        if (this.validCollection(buildFrom.getItems())) {
            for (ItemMapBean itemMapBean : buildFrom.getItems()) {
                ConceptMapType conceptMaptype = conceptSchemeMap.addNewConceptMap();
                if (this.validString(itemMapBean.getSourceId())) {
                    conceptMaptype.setConceptID(itemMapBean.getSourceId());
                }
                if (!this.validString(itemMapBean.getTargetId())) continue;
                conceptMaptype.setTargetConceptID(itemMapBean.getTargetId());
            }
        }
        if (this.hasAnnotations(buildFrom)) {
            conceptSchemeMap.setAnnotations(this.getAnnotationsType(buildFrom));
        }
    }

    private void processOrganisationSchemeMap(StructureSetType structureSetType, OrganisationSchemeMapBean buildFrom) {
        OrganisationSchemeRefType refType;
        OrganisationSchemeMapType orgSchemeMap = structureSetType.addNewOrganisationSchemeMap();
        if (this.validString(buildFrom.getId())) {
            orgSchemeMap.setId(buildFrom.getId());
        }
        if (this.validCollection(buildFrom.getNames())) {
            orgSchemeMap.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            orgSchemeMap.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (buildFrom.getSourceRef() != null) {
            refType = orgSchemeMap.addNewOrganisationSchemeRef();
            this.setOrganisationSchemeRefAttributes(refType, buildFrom.getSourceRef());
        }
        if (buildFrom.getTargetRef() != null) {
            refType = orgSchemeMap.addNewTargetOrganisationSchemeRef();
            this.setOrganisationSchemeRefAttributes(refType, buildFrom.getTargetRef());
        }
        if (this.validCollection(buildFrom.getItems())) {
            for (ItemMapBean itemMapBean : buildFrom.getItems()) {
                OrganisationMapType orgMaptype = orgSchemeMap.addNewOrganisationMap();
                if (this.validString(itemMapBean.getSourceId())) {
                    orgMaptype.setOrganisationID(itemMapBean.getSourceId());
                }
                if (!this.validString(itemMapBean.getTargetId())) continue;
                orgMaptype.setTargetOrganisationID(itemMapBean.getTargetId());
            }
        }
        if (this.hasAnnotations(buildFrom)) {
            orgSchemeMap.setAnnotations(this.getAnnotationsType(buildFrom));
        }
    }

    private void setDataStructureRefAttributes(KeyFamilyRefType kfRefType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            kfRefType.setKeyFamilyAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            kfRefType.setKeyFamilyID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            kfRefType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            kfRefType.setVersion(mRef.getVersion());
        }
    }

    private void setMetadataStructureRefAttributes(MetadataStructureRefType refType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            refType.setMetadataStructureAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            refType.setMetadataStructureID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            refType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void setCodelistRefAttributes(CodelistRefType refType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            refType.setAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            refType.setCodelistID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            refType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void setConceptSchemeRefAttributes(ConceptSchemeRefType refType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            refType.setAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            refType.setConceptSchemeID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            refType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void setCategorySchemeRefAttributes(CategorySchemeRefType refType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            refType.setAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            refType.setCategorySchemeID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            refType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void setOrganisationSchemeRefAttributes(OrganisationSchemeRefType refType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            refType.setAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            refType.setOrganisationSchemeID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            refType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void setHclRefAttributes(HierarchicalCodelistRefType refType, CrossReferenceBean ref) {
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (this.validString(mRef.getAgencyId())) {
            refType.setAgencyID(mRef.getAgencyId());
        }
        if (this.validString(mRef.getMaintainableId())) {
            refType.setHierarchicalCodelistID(mRef.getMaintainableId());
        }
        if (this.validString(ref.getTargetUrn())) {
            refType.setURN(ref.getTargetUrn());
        }
        if (this.validString(mRef.getVersion())) {
            refType.setVersion(mRef.getVersion());
        }
    }
}

