/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import org.sdmx.resources.sdmxml.schemas.v21.common.LocalProcessStepReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComputationType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.InputOutputType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TransitionType;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.process.ComputationBean;
import org.sdmxsource.sdmx.api.model.beans.process.InputOutputBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.NameableBeanAssembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class ProcessStepBeanAssembler
extends NameableBeanAssembler
implements Assembler<ProcessStepType, ProcessStepBean> {
    @Override
    public void assemble(ProcessStepType assembleInto, ProcessStepBean assembleFrom) throws BuilderException {
        this.assembleNameable(assembleInto, assembleFrom);
        for (InputOutputBean currentInput : assembleFrom.getInput()) {
            this.assembleInputOutput(currentInput, assembleInto.addNewInput());
        }
        for (InputOutputBean currentOutput : assembleFrom.getOutput()) {
            this.assembleInputOutput(currentOutput, assembleInto.addNewOutput());
        }
        if (assembleFrom.getComputation() != null) {
            this.assembleComputation(assembleFrom.getComputation(), assembleInto.addNewComputation());
        }
        for (TransitionBean currentTranistion : assembleFrom.getTransitions()) {
            this.assembleTransition(currentTranistion, assembleInto.addNewTransition());
        }
        for (ProcessStepBean eachProcessStepBean : assembleFrom.getProcessSteps()) {
            ProcessStepType eachProcessStep = assembleInto.addNewProcessStep();
            this.assemble(eachProcessStep, eachProcessStepBean);
        }
    }

    private void assembleInputOutput(InputOutputBean currentInput, InputOutputType ioType) {
        if (ObjectUtil.validString(currentInput.getLocalId())) {
            ioType.setLocalID(currentInput.getLocalId());
        }
        if (this.hasAnnotations(currentInput)) {
            ioType.setAnnotations(this.getAnnotationsType(currentInput));
        }
        if (currentInput.getStructureReference() != null) {
            super.setReference(ioType.addNewObjectReference().addNewRef(), currentInput.getStructureReference());
        }
    }

    private void assembleComputation(ComputationBean computationBean, ComputationType computationType) {
        if (ObjectUtil.validString(computationBean.getLocalId())) {
            computationType.setLocalID(computationBean.getLocalId());
        }
        if (ObjectUtil.validString(computationBean.getSoftwarePackage())) {
            computationType.setSoftwarePackage(computationBean.getSoftwarePackage());
        }
        if (ObjectUtil.validString(computationBean.getSoftwareLanguage())) {
            computationType.setSoftwareLanguage(computationBean.getSoftwareLanguage());
        }
        if (ObjectUtil.validString(computationBean.getSoftwareVersion())) {
            computationType.setSoftwareVersion(computationBean.getSoftwareVersion());
        }
        if (this.hasAnnotations(computationBean)) {
            computationType.setAnnotations(this.getAnnotationsType(computationBean));
        }
        if (this.validCollection(computationBean.getDescription())) {
            computationType.setDescriptionArray(this.getTextType(computationBean.getDescription()));
        }
    }

    private void assembleTransition(TransitionBean transitionBean, TransitionType transitionType) {
        if (ObjectUtil.validString(transitionBean.getLocalId())) {
            transitionType.setLocalID(transitionBean.getLocalId());
        }
        super.assembleIdentifiable(transitionType, transitionBean);
        if (transitionBean.getTargetStep() != null) {
            LocalProcessStepReferenceType procRef = transitionType.addNewTargetStep();
            RefBaseType ref = procRef.addNewRef();
            ref.setId(transitionBean.getTargetStep().getId());
        }
        if (ObjectUtil.validCollection(transitionBean.getCondition())) {
            transitionType.setConditionArray(this.getTextType(transitionBean.getCondition()));
        }
    }
}

