/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.rid;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v21.common.ActionType;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.RegistrationRequestType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.RegistrationType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubmitRegistrationsRequestType;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.exception.BuilderException;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21.V2_1Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.RegistrationXmlBeanBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubmitRegistrationBuilder {
    @Autowired
    private RegistrationXmlBeanBuilder registrationXmlBeanBuilder;

    public RegistryInterfaceDocument buildRegistryInterfaceDocument(Collection<RegistrationBean> buildFrom, DATASET_ACTION action) throws BuilderException {
        RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType rit = rid.addNewRegistryInterface();
        V2_1Helper.setHeader(rit);
        SubmitRegistrationsRequestType submitRegistrationRequest = rit.addNewSubmitRegistrationsRequest();
        for (RegistrationBean currentRegistration : buildFrom) {
            RegistrationType registrationType = this.registrationXmlBeanBuilder.build(currentRegistration);
            RegistrationRequestType registrationRequest = submitRegistrationRequest.addNewRegistrationRequest();
            registrationRequest.setRegistration(registrationType);
            switch (action) {
                case APPEND: {
                    registrationRequest.setAction(ActionType.APPEND);
                    break;
                }
                case REPLACE: {
                    registrationRequest.setAction(ActionType.REPLACE);
                    break;
                }
                case DELETE: {
                    registrationRequest.setAction(ActionType.DELETE);
                    break;
                }
                case INFORMATION: {
                    registrationRequest.setAction(ActionType.INFORMATION);
                }
            }
        }
        return rid;
    }
}

