/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.impl;

import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.StructureWorkspace;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.structureparser.manager.ExternalReferenceManager;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.util.io.ReadableDataLocationTmp;
import org.sdmxsource.util.io.URIUtil;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalReferenceManagerImpl
implements ExternalReferenceManager {
    private static final Logger LOG = Logger.getLogger(ExternalReferenceManagerImpl.class);
    @Autowired
    private StructureParsingManager structureParsingManager;
    private static final ResolutionSettings retriervalSettings = new ResolutionSettings(ResolutionSettings.RESOLVE_EXTERNAL_SETTING.DO_NOT_RESOLVE, ResolutionSettings.RESOLVE_CROSS_REFERENCES.DO_NOT_RESOLVE, 0);

    @Override
    public SdmxBeans resolveExternalReferences(SdmxBeans structures, boolean isSubstitute, boolean isLienient) throws ValidationException, ReferenceException {
        LOG.info((Object)("Check for External References, Substititue=" + isSubstitute + " Lienient=" + isLienient));
        SdmxBeansImpl returnBeans = new SdmxBeansImpl();
        if (structures == null) {
            return returnBeans;
        }
        this.resolveBeans(structures.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]), returnBeans, isLienient);
        LOG.info((Object)("Number of External References=" + returnBeans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0]).size()));
        if (isSubstitute) {
            structures.merge(returnBeans);
        }
        return returnBeans;
    }

    private void resolveBeans(Set<? extends MaintainableBean> maintinableBeans, SdmxBeans returnBeans, boolean isLienient) {
        for (MaintainableBean maintainableBean : maintinableBeans) {
            if (!maintainableBean.isExternalReference().isTrue()) continue;
            SdmxBeans retrievedStructures = this.resolve(maintainableBean, isLienient);
            if (retrievedStructures != null) {
                MaintainableBean resolvedReference = MaintainableUtil.resolveReference(retrievedStructures.getCodelists(), maintainableBean.asReference());
                if (resolvedReference == null) {
                    LOG.warn((Object)("External Reference " + maintainableBean.getStructureURL() + " does not contain structure: " + maintainableBean.getUrn()));
                    this.addException(maintainableBean, isLienient);
                    continue;
                }
                returnBeans.addIdentifiable(resolvedReference);
                continue;
            }
            LOG.warn((Object)("Can not resolve external reference for structure " + maintainableBean.getUrn() + ", URL does not contain SDMX structures: " + maintainableBean.getStructureURL()));
        }
    }

    private SdmxBeans resolve(MaintainableBean maintBean, boolean isLienient) {
        block11: {
            URI uri = null;
            try {
                URL urlLocation = maintBean.getStructureURL();
                if (urlLocation == null) {
                    LOG.warn((Object)("Can not resolve external reference for structure " + maintBean.getUrn() + " Structure URL is not set "));
                    this.addException(maintBean, isLienient);
                    break block11;
                }
                ReadableDataLocationTmp dataLocation = new ReadableDataLocationTmp(urlLocation);
                StructureWorkspace sw = this.structureParsingManager.parseStructures(dataLocation, retriervalSettings, null);
                SdmxBeans sdmxBeans = sw.getStructureBeans(false);
                return sdmxBeans;
            }
            catch (ReferenceException refEx) {
                if (isLienient) {
                    this.addException(maintBean, refEx.getMessage());
                    break block11;
                }
                throw refEx;
            }
            catch (Throwable th) {
                if (isLienient) {
                    this.addException(maintBean, th.getMessage());
                    break block11;
                }
                throw new RuntimeException(th);
            }
            finally {
                if (uri != null) {
                    URIUtil.closeUri(uri);
                    URIUtil.deleteUri(uri);
                }
            }
        }
        return null;
    }

    private void addException(MaintainableBean maintBean, boolean isLienient) {
        if (isLienient) {
            if (maintBean.getStructureURL() == null) {
                this.addException(maintBean, "External location not set");
            } else {
                this.addException(maintBean, "External location `" + maintBean.getStructureURL().toString() + "` does not contain structure : " + maintBean.getUrn());
            }
        } else {
            if (maintBean.getStructureURL() == null) {
                throw new ReferenceException(ExceptionCode.EXTERNAL_STRUCTURE_NOT_FOUND_AT_URI, maintBean.getUrn(), "NOT SET");
            }
            throw new ReferenceException(ExceptionCode.EXTERNAL_STRUCTURE_NOT_FOUND_AT_URI, maintBean.getUrn(), maintBean.getStructureURL().toString());
        }
    }

    private void addException(MaintainableBean maintBean, String message) {
        LoggingUtil.error(LOG, message);
    }

    public void setStructureParsingManager(StructureParsingManager structureParsingManager) {
        this.structureParsingManager = structureParsingManager;
    }
}

