/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryResultType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.RegistrationType;
import org.sdmx.resources.sdmxml.schemas.v21.common.CodedStatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v21.message.ErrorDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.RegistrationRequestType;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.model.beans.RegistrationInformation;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.RegistrationInformationImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.RegistrationBeanImpl;
import org.sdmxsource.sdmx.structureparser.manager.parsing.RegistrationParsingManager;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class RegistrationParsingManagerImpl
implements RegistrationParsingManager {
    @Override
    public List<RegistrationInformation> parseRegXML(ReadableDataLocation dataLocation) {
        SDMX_SCHEMA schemaVersion = SdmxMessageUtil.getSchemaVersion(dataLocation);
        XMLParser.validateXML(dataLocation, schemaVersion, new ReadableDataLocation[0]);
        MESSAGE_TYPE messageType = SdmxMessageUtil.getMessageType(dataLocation);
        if (messageType != MESSAGE_TYPE.ERROR && messageType != MESSAGE_TYPE.REGISTRY_INTERFACE) {
            throw new RuntimeException("Unexpected Document found, expecting RegistryInterfaceDocument containing Registrations, received " + messageType.getNodeName());
        }
        InputStream stream = dataLocation.getInputStream();
        try {
            if (messageType == MESSAGE_TYPE.ERROR) {
                ErrorDocument errorDocument = ErrorDocument.Factory.parse(stream);
                Iterator<CodedStatusMessageType> iterator = errorDocument.getError().getErrorMessageList().iterator();
                if (iterator.hasNext()) {
                    CodedStatusMessageType csmt = iterator.next();
                    if (csmt.getCode() != null && csmt.getCode().equals("100")) {
                        ArrayList<RegistrationInformation> arrayList = new ArrayList<RegistrationInformation>();
                        return arrayList;
                    }
                    throw new RuntimeException(csmt.getTextArray()[0].getStringValue());
                }
                ArrayList<RegistrationInformation> arrayList = new ArrayList<RegistrationInformation>();
                return arrayList;
            }
            List<RegistrationInformation> list = this.processResigtrationResponse(schemaVersion, stream);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("A error occured whilst trying to read the XML stream", e);
        }
        catch (XmlException e) {
            throw new RuntimeException("A error occured whilst trying to process the XML stream", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private List<RegistrationInformation> processResigtrationResponse(SDMX_SCHEMA schemaVersion, InputStream stream) throws IOException, XmlException {
        ArrayList<RegistrationInformation> returnList = new ArrayList<RegistrationInformation>();
        switch (schemaVersion) {
            case VERSION_TWO: {
                DATASET_ACTION action;
                RegistrationBeanImpl registration;
                org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.parse(stream);
                if (rid.getRegistryInterface().getQueryRegistrationResponse() != null && rid.getRegistryInterface().getQueryRegistrationResponse().getQueryResultList() != null) {
                    for (QueryResultType resultType : rid.getRegistryInterface().getQueryRegistrationResponse().getQueryResultList()) {
                        if (resultType.getDataResult() == null) continue;
                        registration = new RegistrationBeanImpl(resultType.getDataResult().getProvisionAgreementRef(), resultType.getDataResult().getDatasource());
                        action = DATASET_ACTION.INFORMATION;
                        returnList.add(new RegistrationInformationImpl(action, registration));
                    }
                }
                if (rid.getRegistryInterface().getSubmitRegistrationRequest() == null || rid.getRegistryInterface().getSubmitRegistrationRequest().getRegistrationList() == null) break;
                for (RegistrationType registrationType : rid.getRegistryInterface().getSubmitRegistrationRequest().getRegistrationList()) {
                    registration = new RegistrationBeanImpl(registrationType);
                    action = DATASET_ACTION.APPEND;
                    switch (registrationType.getAction().intValue()) {
                        case 1: {
                            action = DATASET_ACTION.APPEND;
                            break;
                        }
                        case 3: {
                            action = DATASET_ACTION.DELETE;
                            break;
                        }
                        case 2: {
                            action = DATASET_ACTION.REPLACE;
                        }
                    }
                    returnList.add(new RegistrationInformationImpl(action, registration));
                }
                break;
            }
            case VERSION_TWO_POINT_ONE: {
                RegistryInterfaceDocument rid2_1 = RegistryInterfaceDocument.Factory.parse(stream);
                RegistryInterfaceType rit = rid2_1.getRegistryInterface();
                if (rit.getSubmitRegistrationsRequest() != null && rit.getSubmitRegistrationsRequest().getRegistrationRequestList() != null) {
                    for (RegistrationRequestType rt : rit.getSubmitRegistrationsRequest().getRegistrationRequestList()) {
                        DATASET_ACTION action = DATASET_ACTION.APPEND;
                        switch (rt.getAction().intValue()) {
                            case 1: {
                                action = DATASET_ACTION.APPEND;
                                break;
                            }
                            case 3: {
                                action = DATASET_ACTION.DELETE;
                                break;
                            }
                            case 2: {
                                action = DATASET_ACTION.REPLACE;
                            }
                        }
                        if (!(action != DATASET_ACTION.DELETE && action != DATASET_ACTION.REPLACE || ObjectUtil.validString(rt.getRegistration().getId()))) {
                            throw new IllegalArgumentException("Registration submissions with REPLACE or DELETE actions must contain an id identifing the Registration to perform this action on");
                        }
                        RegistrationBeanImpl registration = new RegistrationBeanImpl(rt.getRegistration());
                        returnList.add(new RegistrationInformationImpl(action, registration));
                    }
                }
                if (rit.getQueryRegistrationResponse() == null || rit.getQueryRegistrationResponse().getQueryResultList() == null) break;
                for (org.sdmx.resources.sdmxml.schemas.v21.registry.QueryResultType queryResult : rit.getQueryRegistrationResponse().getQueryResultList()) {
                    RegistrationBeanImpl registration;
                    if (queryResult.getDataResult() != null && queryResult.getDataResult().getRegistration() != null) {
                        registration = new RegistrationBeanImpl(queryResult.getDataResult().getRegistration());
                        returnList.add(new RegistrationInformationImpl(DATASET_ACTION.INFORMATION, registration));
                    }
                    if (queryResult.getMetadataResult() == null || queryResult.getMetadataResult().getRegistration() == null) continue;
                    registration = new RegistrationBeanImpl(queryResult.getDataResult().getRegistration());
                    returnList.add(new RegistrationInformationImpl(DATASET_ACTION.INFORMATION, registration));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Schema version unsupported: " + schemaVersion.toString());
            }
        }
        return returnList;
    }
}

