/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureDocument;
import org.sdmxsource.sdmx.api.constants.ARTIFACT_TYPE;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.REGISTRY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.exception.ValidationException;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.StructureWorkspace;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.manager.EdiParseManager;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.SdmxBeansBuilder;
import org.sdmxsource.sdmx.structureparser.manager.ExternalReferenceManager;
import org.sdmxsource.sdmx.structureparser.manager.parsing.ProvisionParsingManager;
import org.sdmxsource.sdmx.structureparser.manager.parsing.RegistrationParsingManager;
import org.sdmxsource.sdmx.structureparser.manager.parsing.SubscriptionParsingManager;
import org.sdmxsource.sdmx.structureparser.workspace.impl.StructureWorkspaceImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureParsingManagerImpl
implements StructureParsingManager {
    private Logger LOG = Logger.getLogger(StructureParsingManagerImpl.class);
    @Autowired
    private ExternalReferenceManager externalReferenceManager;
    @Autowired
    private SdmxBeansBuilder sdmxBeansBuilder;
    @Autowired
    private EdiParseManager ediParseManager;
    @Autowired
    private ProvisionParsingManager provisionParsingManager;
    @Autowired
    private RegistrationParsingManager registrationParsingManager;
    @Autowired
    private SubscriptionParsingManager subscriptionParsingManager;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE;

    @Override
    public StructureWorkspace parseStructures(ReadableDataLocation dataLocation) throws ValidationException, ReferenceException {
        ResolutionSettings settings = new ResolutionSettings(ResolutionSettings.RESOLVE_EXTERNAL_SETTING.DO_NOT_RESOLVE, ResolutionSettings.RESOLVE_CROSS_REFERENCES.DO_NOT_RESOLVE);
        return this.parseStructures(dataLocation, settings, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StructureWorkspace parseStructures(ReadableDataLocation dataLocation, ResolutionSettings settings, SdmxBeanRetrievalManager retrievalManager) {
        StructureWorkspace structureWorkspace;
        SDMX_SCHEMA schemaVersion;
        block27: {
            this.LOG.info((Object)("Parse structures, resolution settings: " + settings + ", retrieval manager=" + retrievalManager));
            InputStream stream = null;
            schemaVersion = SdmxMessageUtil.getSchemaVersion(dataLocation);
            try {
                this.LOG.info((Object)("Schema Version : " + (Object)((Object)schemaVersion)));
                MESSAGE_TYPE messageType = null;
                if (schemaVersion != SDMX_SCHEMA.EDI) {
                    messageType = SdmxMessageUtil.getMessageType(dataLocation);
                    this.LOG.info((Object)("Message type: " + (Object)((Object)messageType)));
                }
                if (schemaVersion.isXmlFormat()) {
                    XMLParser.validateXML(dataLocation, schemaVersion, new ReadableDataLocation[0]);
                    LoggingUtil.debug(this.LOG, "XML VALID");
                }
                SdmxBeans beans = null;
                REGISTRY_MESSAGE_TYPE registryMessage = null;
                if (messageType == MESSAGE_TYPE.REGISTRY_INTERFACE) {
                    registryMessage = SdmxMessageUtil.getRegistryMessageType(dataLocation);
                    beans = this.processRegistryInterfaceDocument(dataLocation, registryMessage, schemaVersion);
                } else {
                    stream = dataLocation.getInputStream();
                    block2 : switch (schemaVersion) {
                        case VERSION_ONE: {
                            StructureDocument sdV1 = StructureDocument.Factory.parse(stream);
                            beans = this.sdmxBeansBuilder.build(sdV1);
                            break;
                        }
                        case VERSION_TWO: {
                            switch (messageType) {
                                case STRUCTURE: {
                                    org.sdmx.resources.sdmxml.schemas.v20.message.StructureDocument sdV2 = StructureDocument.Factory.parse(stream);
                                    beans = this.sdmxBeansBuilder.build(sdV2);
                                    break block2;
                                }
                                case REGISTRY_INTERFACE: {
                                    RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.parse(stream);
                                    beans = this.sdmxBeansBuilder.build(rid);
                                    break block2;
                                }
                            }
                            throw new IllegalArgumentException("StructureParsingManagerImpl can not parse document '" + (Object)((Object)messageType) + "' was expecting Structure document or RegistryInterface document");
                        }
                        case VERSION_TWO_POINT_ONE: {
                            switch (messageType) {
                                case STRUCTURE: {
                                    org.sdmx.resources.sdmxml.schemas.v21.message.StructureDocument sdV2_1 = StructureDocument.Factory.parse(stream);
                                    beans = this.sdmxBeansBuilder.build(sdV2_1);
                                    break block2;
                                }
                                case ERROR: {
                                    beans = new SdmxBeansImpl();
                                    break block2;
                                }
                            }
                            throw new IllegalArgumentException("StructureParsingManagerImpl can not parse document '" + (Object)((Object)messageType) + "' was expecting Structure document or Error document");
                        }
                        case EDI: {
                            EDIWorkspace ediWorkspace = this.ediParseManager.parseEDIMessage(dataLocation);
                            if (ediWorkspace.hasStructures()) {
                                beans = ediWorkspace.getMergedBeans();
                                break;
                            }
                            beans = new SdmxBeansImpl();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Schema version unsupported: " + schemaVersion.toString());
                        }
                    }
                }
                structureWorkspace = this.buildWorkspace(beans, settings, retrievalManager);
                if (stream == null) break block27;
            }
            catch (XmlException e) {
                try {
                    throw new RuntimeException(e);
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        StreamUtil.closeStream(stream);
                    }
                    if (schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE) {
                        dataLocation.close();
                    }
                    throw throwable;
                }
            }
            StreamUtil.closeStream(stream);
        }
        if (schemaVersion == SDMX_SCHEMA.VERSION_TWO_POINT_ONE) {
            dataLocation.close();
        }
        return structureWorkspace;
    }

    @Override
    public StructureWorkspace buildWorkspace(SdmxBeans beans, ResolutionSettings settings, SdmxBeanRetrievalManager retrievalManager) {
        if (settings.isResolveExternalReferences()) {
            this.externalReferenceManager.resolveExternalReferences(beans, settings.isSubstituteExternal(), settings.isLenient());
        }
        return new StructureWorkspaceImpl(beans, retrievalManager, settings.isResolveCrossReferences(), settings.isResolveAgencyReferences(), settings.getResolutionDepth());
    }

    /*
     * Exception decompiling
     */
    private SdmxBeans processRegistryInterfaceDocument(ReadableDataLocation dataLocation, REGISTRY_MESSAGE_TYPE registryMessage, SDMX_SCHEMA schemaVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE() {
        if ($SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE != null) {
            return $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE;
        }
        int[] nArray = new int[ARTIFACT_TYPE.values().length];
        try {
            nArray[ARTIFACT_TYPE.DATA.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.METADATA.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.NOTIFICATION.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.PROVISION.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.REGISTRATION.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.STRUCTURE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.SUBSCRIPTION.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE = nArray;
        return nArray;
    }
}

