/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.parsing.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_OUTPUT_FORMAT;
import org.sdmxsource.sdmx.api.manager.output.StructureWritingManager;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.structureparser.manager.parsing.StructureValidationManager;
import org.sdmxsource.util.io.ReadableDataLocationTmp;
import org.sdmxsource.util.io.StreamUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StructureValidationManagerImpl
implements StructureValidationManager {
    @Autowired
    private StructureParsingManager structureParsingManager;
    @Autowired
    private StructureWritingManager structureWritingManager;

    @Override
    public void validateStructure(MaintainableBean maintainableBean) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.structureWritingManager.writeStructure(maintainableBean, null, STRUCTURE_OUTPUT_FORMAT.SDMX_V21_STRUCTURE_DOCUMENT, out);
        ReadableDataLocationTmp dataLocation = new ReadableDataLocationTmp(new ByteArrayInputStream(out.toByteArray()));
        this.structureParsingManager.parseStructures(dataLocation);
        StreamUtil.closeStream(out);
    }
}

