/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Set;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.ReferenceException;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;

public abstract class BaseSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager {
    private SdmxBeanRetrievalManager proxy;

    @Override
    public MaintainableBean getMaintainable(StructureReferenceBean query) throws ReferenceException {
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (query.getMaintainableStructureType()) {
            case AGENCY_SCHEME: {
                return this.getAgencySchemeBean(ref);
            }
            case ATTACHMENT_CONSTRAINT: {
                return this.getAttachmentConstraint(ref);
            }
            case CONTENT_CONSTRAINT: {
                return this.getContentConstraint(ref);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.getDataConsumerSchemeBean(ref);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.getDataProviderSchemeBean(ref);
            }
            case CATEGORISATION: {
                return this.getCategorisation(ref);
            }
            case CATEGORY_SCHEME: {
                return this.getCategoryScheme(ref);
            }
            case CODE_LIST: {
                return this.getCodelist(ref);
            }
            case CONCEPT_SCHEME: {
                return this.getConceptScheme(ref);
            }
            case DATAFLOW: {
                return this.getDataflow(ref);
            }
            case HIERARCHICAL_CODELIST: {
                return this.getHierarchicCodeList(ref);
            }
            case DSD: {
                return this.getDataStructure(ref);
            }
            case METADATA_FLOW: {
                return this.getMetadataflow(ref);
            }
            case MSD: {
                return this.getMetadataStructure(ref);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.getOrganisationUnitScheme(ref);
            }
            case PROCESS: {
                return this.getProcessBean(ref);
            }
            case REPORTING_TAXONOMY: {
                return this.getReportingTaxonomy(ref);
            }
            case STRUCTURE_SET: {
                return this.getStructureSet(ref);
            }
            case PROVISION_AGREEMENT: {
                return this.getProvisionAgreementBean(ref);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{query.getTargetReference()});
    }

    public void setProxy(SdmxBeanRetrievalManager proxy) {
        this.proxy = proxy;
    }

    @Override
    public AgencyBean getAgency(String id) {
        for (AgencySchemeBean currentAgencySchemeBean : this.getAgencySchemeBeans(null)) {
            for (AgencyBean currentAgencyBean : currentAgencySchemeBean.getItems()) {
                if (!currentAgencyBean.getFullId().equals(id)) continue;
                return currentAgencyBean;
            }
        }
        return null;
    }

    @Override
    public Set<MaintainableBean> getMaintainableWithReferences(StructureReferenceBean query) throws ReferenceException {
        if (this.proxy != null) {
            return this.proxy.getMaintainableWithReferences(query);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getMaintainableWithReferences");
    }

    @Override
    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getAttachmentConstraints(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getAttachmentConstraints");
    }

    @Override
    public Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getCategorisationBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getCategorisationBeans");
    }

    @Override
    public Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getCodelistBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getCodelistBeans");
    }

    @Override
    public Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getConceptSchemeBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getConceptSchemeBeans");
    }

    @Override
    public Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getContentConstraints(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getContentConstraints");
    }

    @Override
    public Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getCategorySchemeBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getCategorySchemeBeans");
    }

    @Override
    public Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getDataflowBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getDataflowBeans");
    }

    @Override
    public Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getHierarchicCodeListBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getHierarchicCodeListBeans");
    }

    @Override
    public Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getMetadataflowBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getMetadataflowBeans");
    }

    @Override
    public Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getDataStructureBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getDataStructureBeans");
    }

    @Override
    public Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getMetadataStructureBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getMetadataStructureBeans");
    }

    @Override
    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getOrganisationUnitSchemeBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getOrganisationUnitSchemeBeans");
    }

    @Override
    public Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getDataProviderSchemeBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getDataProviderSchemeBeans");
    }

    @Override
    public Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getDataConsumerSchemeBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getDataConsumerSchemeBeans");
    }

    @Override
    public Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getAgencySchemeBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getAgencySchemeBeans");
    }

    @Override
    public Set<ProcessBean> getProcessBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getProcessBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getProcessBeans");
    }

    @Override
    public Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getProvisionAgreementBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getProvisionAgreementBeans");
    }

    @Override
    public Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getReportingTaxonomyBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getReportingTaxonomyBeans");
    }

    @Override
    public Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref) {
        if (this.proxy != null) {
            return this.proxy.getStructureSetBeans(ref);
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "getStructureSetBeans");
    }

    @Override
    public AgencySchemeBean getAgencySchemeBean(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getAgencySchemeBeans(ref), ref);
        return (AgencySchemeBean)maint;
    }

    @Override
    public DataConsumerSchemeBean getDataConsumerSchemeBean(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataConsumerSchemeBeans(ref), ref);
        return (DataConsumerSchemeBean)maint;
    }

    @Override
    public AttachmentConstraintBean getAttachmentConstraint(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getAttachmentConstraints(ref), ref);
        return (AttachmentConstraintBean)maint;
    }

    @Override
    public ContentConstraintBean getContentConstraint(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getContentConstraints(ref), ref);
        return (ContentConstraintBean)maint;
    }

    @Override
    public DataProviderSchemeBean getDataProviderSchemeBean(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataProviderSchemeBeans(ref), ref);
        return (DataProviderSchemeBean)maint;
    }

    @Override
    public OrganisationUnitSchemeBean getOrganisationUnitScheme(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getOrganisationUnitSchemeBeans(ref), ref);
        return (OrganisationUnitSchemeBean)maint;
    }

    @Override
    public CategorisationBean getCategorisation(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getCategorisationBeans(ref), ref);
        return (CategorisationBean)maint;
    }

    @Override
    public CategorySchemeBean getCategoryScheme(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getCategorySchemeBeans(ref), ref);
        return (CategorySchemeBean)maint;
    }

    @Override
    public CodelistBean getCodelist(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getCodelistBeans(ref), ref);
        return (CodelistBean)maint;
    }

    @Override
    public ConceptSchemeBean getConceptScheme(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getConceptSchemeBeans(ref), ref);
        return (ConceptSchemeBean)maint;
    }

    @Override
    public DataflowBean getDataflow(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataflowBeans(ref), ref);
        return (DataflowBean)maint;
    }

    @Override
    public HierarchicalCodelistBean getHierarchicCodeList(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getHierarchicCodeListBeans(ref), ref);
        return (HierarchicalCodelistBean)maint;
    }

    @Override
    public DataStructureBean getDataStructure(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getDataStructureBeans(ref), ref);
        return (DataStructureBean)maint;
    }

    @Override
    public MetadataFlowBean getMetadataflow(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getMetadataflowBeans(ref), ref);
        return (MetadataFlowBean)maint;
    }

    @Override
    public MetadataStructureDefinitionBean getMetadataStructure(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getMetadataStructureBeans(ref), ref);
        return (MetadataStructureDefinitionBean)maint;
    }

    @Override
    public ProcessBean getProcessBean(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getProcessBeans(ref), ref);
        return (ProcessBean)maint;
    }

    @Override
    public ProvisionAgreementBean getProvisionAgreementBean(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getProvisionAgreementBeans(ref), ref);
        return (ProvisionAgreementBean)maint;
    }

    @Override
    public ReportingTaxonomyBean getReportingTaxonomy(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getReportingTaxonomyBeans(ref), ref);
        return (ReportingTaxonomyBean)maint;
    }

    @Override
    public StructureSetBean getStructureSet(MaintainableRefBean ref) {
        MaintainableBean maint = MaintainableUtil.resolveReference(this.getStructureSetBeans(ref), ref);
        return (StructureSetBean)maint;
    }

    protected Set<? extends MaintainableBean> getMaintainables(StructureReferenceBean query) throws ReferenceException {
        if (!query.getTargetReference().isMaintainable()) {
            throw new UnsupportedException(ExceptionCode.UNSUPPORTED, (Object)((Object)query.getTargetReference()) + " is not maintainable");
        }
        MaintainableRefBean ref = query.getMaintainableReference();
        switch (query.getTargetReference()) {
            case AGENCY_SCHEME: {
                return this.getAgencySchemeBeans(ref);
            }
            case DATA_CONSUMER_SCHEME: {
                return this.getDataConsumerSchemeBeans(ref);
            }
            case ATTACHMENT_CONSTRAINT: {
                return this.getAttachmentConstraints(ref);
            }
            case CONTENT_CONSTRAINT: {
                return this.getContentConstraints(ref);
            }
            case DATA_PROVIDER_SCHEME: {
                return this.getDataProviderSchemeBeans(ref);
            }
            case CATEGORISATION: {
                return this.getCategorisationBeans(ref);
            }
            case CATEGORY_SCHEME: {
                return this.getCategorySchemeBeans(ref);
            }
            case CODE_LIST: {
                return this.getCodelistBeans(ref);
            }
            case CONCEPT_SCHEME: {
                return this.getConceptSchemeBeans(ref);
            }
            case DATAFLOW: {
                return this.getDataflowBeans(ref);
            }
            case HIERARCHICAL_CODELIST: {
                return this.getHierarchicCodeListBeans(ref);
            }
            case DSD: {
                return this.getDataStructureBeans(ref);
            }
            case METADATA_FLOW: {
                return this.getMetadataflowBeans(ref);
            }
            case MSD: {
                return this.getMetadataStructureBeans(ref);
            }
            case ORGANISATION_UNIT_SCHEME: {
                return this.getOrganisationUnitSchemeBeans(ref);
            }
            case PROCESS: {
                return this.getProcessBeans(ref);
            }
            case REPORTING_TAXONOMY: {
                return this.getReportingTaxonomyBeans(ref);
            }
            case STRUCTURE_SET: {
                return this.getStructureSetBeans(ref);
            }
            case PROVISION_AGREEMENT: {
                return this.getProvisionAgreementBeans(ref);
            }
        }
        throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{query.getTargetReference()});
    }
}

