/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager.mutable;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.StructureSearchManager;
import org.sdmxsource.sdmx.api.manager.retrieval.mutable.MutableStubBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.RESTStructureQuery;
import org.springframework.beans.factory.annotation.Required;

public class MutableStubBeanRetrievalManagerImpl
implements MutableStubBeanRetrievalManager {
    private StructureSearchManager structureSearchManager;
    private ServiceRetrievalManager serviceRetrievalManager;

    @Override
    public Set<MaintainableMutableBean> getStubBeans(StructureReferenceBean sRef) {
        RESTStructureQuery query = new RESTStructureQuery(STRUCTURE_QUERY_DETAIL.FULL, null, null, sRef, false);
        SdmxBeans beans = this.structureSearchManager.getMaintainables(query);
        HashSet<MaintainableMutableBean> mutableBeans = new HashSet<MaintainableMutableBean>();
        for (MaintainableBean maintainableBean : beans.getAllMaintinables(new SDMX_STRUCTURE_TYPE[0])) {
            if (maintainableBean.isStub()) continue;
            mutableBeans.add(this.serviceRetrievalManager.createStub(maintainableBean).getMutableInstance());
        }
        return mutableBeans;
    }

    @Required
    public void setStructureSearchManager(StructureSearchManager structureSearchManager) {
        this.structureSearchManager = structureSearchManager;
    }

    @Required
    public void setServiceRetrievalManager(ServiceRetrievalManager serviceRetrievalManager) {
        this.serviceRetrievalManager = serviceRetrievalManager;
    }
}

