/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.VersionableUtil;

public class MaintainableUtil<T extends MaintainableBean> {
    public static Set<MaintainableBean> filterCollectionGetLatest(Collection<MaintainableBean> maintianables) {
        HashMap<String, MaintainableBean> resultMap = new HashMap<String, MaintainableBean>();
        boolean filteredResponse = false;
        for (MaintainableBean currentMaint : maintianables) {
            String key = currentMaint.getStructureType().getType() + "_" + currentMaint.getAgencyId() + "_" + currentMaint.getId();
            if (resultMap.containsKey(key)) {
                filteredResponse = true;
                MaintainableBean storedAgainstKey = (MaintainableBean)resultMap.get(key);
                if (!VersionableUtil.isHigherVersion(currentMaint.getVersion(), storedAgainstKey.getVersion())) continue;
                resultMap.put(key, currentMaint);
                continue;
            }
            resultMap.put(key, currentMaint);
        }
        if (filteredResponse) {
            return new HashSet<MaintainableBean>(resultMap.values());
        }
        return new HashSet<MaintainableBean>(maintianables);
    }

    public Set<T> filterCollection(Collection<T> maintianables, MaintainableRefBean ref) {
        HashSet<MaintainableBean> returnSet = new HashSet<MaintainableBean>();
        String agencyId = null;
        String id = null;
        String version = null;
        if (ref != null) {
            agencyId = ref.getAgencyId();
            id = ref.getMaintainableId();
            version = ref.getVersion();
        }
        for (MaintainableBean currentMaintainable : maintianables) {
            if (agencyId != null && !currentMaintainable.getAgencyId().equals(agencyId) || id != null && !currentMaintainable.getId().equals(id) || version != null && !currentMaintainable.getVersion().equals(version)) continue;
            returnSet.add(currentMaintainable);
        }
        return returnSet;
    }

    public static void findMatches(Collection<MaintainableBean> populateCollection, Collection<? extends MaintainableBean> maintianables, StructureReferenceBean ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Ref is null");
        }
        if (maintianables != null) {
            for (MaintainableBean maintainableBean : maintianables) {
                if (!MaintainableUtil.match(maintainableBean, ref)) continue;
                populateCollection.add(maintainableBean);
            }
        }
    }

    public static Set<MaintainableBean> findMatches(Collection<? extends MaintainableBean> maintianables, StructureReferenceBean ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Ref is null");
        }
        HashSet<MaintainableBean> returnSet = new HashSet<MaintainableBean>();
        if (maintianables != null) {
            for (MaintainableBean maintainableBean : maintianables) {
                if (!MaintainableUtil.match(maintainableBean, ref)) continue;
                returnSet.add(maintainableBean);
            }
        }
        return returnSet;
    }

    public static boolean match(MaintainableBean maint, StructureReferenceBean ref) {
        if (ref == null) {
            return true;
        }
        if (ObjectUtil.validString(ref.getMaintainableUrn())) {
            return maint.getUrn().equals(ref.getMaintainableUrn());
        }
        boolean match = true;
        if (ObjectUtil.validString(ref.getMaintainableReference().getAgencyId())) {
            match = maint.getAgencyId().equals(ref.getMaintainableReference().getAgencyId());
        }
        if (match && ObjectUtil.validString(ref.getMaintainableReference().getMaintainableId())) {
            match = maint.getId().equals(ref.getMaintainableReference().getMaintainableId());
        }
        if (match && ObjectUtil.validString(ref.getMaintainableReference().getVersion())) {
            match = maint.getVersion().equals(ref.getMaintainableReference().getVersion());
        }
        return match;
    }

    public static boolean subsetOf(MaintainableRefBean ref, MaintainableRefBean ref2) {
        boolean match = true;
        if (ObjectUtil.validString(ref.getAgencyId())) {
            match = ref.getAgencyId().equals(ref2.getAgencyId());
        }
        if (match && ObjectUtil.validString(ref.getMaintainableId())) {
            match = ref.getMaintainableId().equals(ref2.getMaintainableId());
        }
        if (match && ObjectUtil.validString(ref.getVersion())) {
            match = ref.getVersion().equals(ref2.getVersion());
        }
        return match;
    }

    public static MaintainableBean resolveReference(Collection<? extends MaintainableBean> maintianables, StructureReferenceBean ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Ref is null");
        }
        MaintainableRefBean mRef = ref.getMaintainableReference();
        if (!ObjectUtil.validString(ref.getTargetUrn()) && !ObjectUtil.validString(mRef.getAgencyId(), mRef.getMaintainableId(), mRef.getVersion())) {
            throw new IllegalArgumentException("Ref requires a URN or AgencyId, Maintainable Id and Version");
        }
        if (maintianables != null) {
            for (MaintainableBean maintainableBean : maintianables) {
                if (maintainableBean.getStructureType() != ref.getMaintainableStructureType() || mRef.getAgencyId() != null && !maintainableBean.getAgencyId().equals(mRef.getAgencyId()) || mRef.getMaintainableId() != null && !maintainableBean.getId().equals(mRef.getMaintainableId()) || mRef.getVersion() != null && !maintainableBean.getVersion().equals(mRef.getVersion())) continue;
                return maintainableBean;
            }
        }
        return null;
    }

    public static MaintainableBean resolveReference(Collection<? extends MaintainableBean> maintainables, MaintainableRefBean ref) {
        if (!ObjectUtil.validCollection(maintainables)) {
            return null;
        }
        if (ref == null) {
            if (maintainables.size() == 1) {
                return maintainables.iterator().next();
            }
            throw new IllegalArgumentException("Can not resolve reference, more then one bean supplied and no reference parameters passed in");
        }
        if (maintainables != null) {
            for (MaintainableBean maintainableBean : maintainables) {
                if (ref.getAgencyId() != null && !maintainableBean.getAgencyId().equals(ref.getAgencyId()) || ref.getMaintainableId() != null && !maintainableBean.getId().equals(ref.getMaintainableId()) || ref.getVersion() != null && !maintainableBean.getVersion().equals(ref.getVersion())) continue;
                return maintainableBean;
            }
        }
        return null;
    }
}

