/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xmlbeans.XmlCalendar;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.UnsupportedException;
import org.sdmxsource.sdmx.api.exception.ValidationException;

public class DateUtil {
    private static final String xmlDatePatternString = "[0-9][0-9][0-9][0-9]-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))";
    private static final String xmlTimePatternString = "([0-1][0-9]|2[0-3]):([0-5][0-9])(:[0-5][0-9])?(.[0-9]*)?(Z|((\\+|-)([0-1][0-9]|2[0-3]):([0-5][0-9])))?";
    private static final Pattern xmlHourlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))T([0-1][0-9]|2[0-3]):([0-5][0-9])(:[0-5][0-9])?(.[0-9]*)?(Z|((\\+|-)([0-1][0-9]|2[0-3]):([0-5][0-9])))?");
    private static final Pattern xmlDailyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-((01|03|05|07|08|10|12)-((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])|02-((0[1-9])|(1[0-9])|(2[0-9]))|(04|06|09|11)-((0[1-9])|(1[0-9])|(2[0-9])|30))");
    private static final Pattern xmlWeeklyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-W([1-9]|[1-4][0-9]|5[0-3])");
    private static final Pattern xmlMonthlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-(0[1-9]|1[0-2])");
    private static final Pattern xmlQuarterlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-Q[1-4]");
    private static final Pattern xmlSemiAnnualPattern = Pattern.compile("[0-9][0-9][0-9][0-9]-B[1-2]");
    private static final Pattern xmlYearlyPattern = Pattern.compile("[0-9][0-9][0-9][0-9]");

    public static Calendar createCalendar(Date date) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Calendar cal = DateUtil.getCalendar();
        cal.setTime(date);
        return cal;
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(Date date) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        if (date == null) {
            return null;
        }
        try {
            Calendar now = DateUtil.getCalendar();
            now.setTime(date);
            GregorianCalendar cal = new GregorianCalendar(now.get(1), now.get(2), now.get(5), now.get(10), now.get(12), now.get(13));
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static Date moveToEndofPeriod(Date date, TIME_FORMAT timeFormat) {
        String dateAsString = DateUtil.formatDate(date, timeFormat);
        return DateUtil.formatDateEndPeriod(dateAsString);
    }

    public static Date formatDate(Object dateObject, boolean startOfPeriod) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        if (dateObject == null) {
            return null;
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        if (dateObject instanceof XmlCalendar) {
            if (startOfPeriod) {
                return DateUtil.formatDateStartPeriod(dateObject.toString());
            }
            return DateUtil.formatDateEndPeriod(dateObject.toString());
        }
        if (dateObject instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar gregorianCal = (XMLGregorianCalendar)dateObject;
            Calendar cal = DateUtil.getCalendar();
            cal.set(1, gregorianCal.getYear());
            cal.set(2, gregorianCal.getMonth() - 1);
            cal.set(5, gregorianCal.getDay());
            cal.set(9, 0);
            if (gregorianCal.getHour() > 0) {
                cal.set(10, gregorianCal.getHour());
            } else {
                cal.set(10, 0);
            }
            if (gregorianCal.getMinute() > 0) {
                cal.set(12, gregorianCal.getMinute());
            } else {
                cal.set(12, 0);
            }
            if (gregorianCal.getSecond() > 0) {
                cal.set(13, gregorianCal.getSecond());
            } else {
                cal.set(13, 0);
            }
            cal.set(14, 0);
            return cal.getTime();
        }
        String dateString = null;
        if (!(dateObject instanceof String)) {
            throw new IllegalArgumentException("Date type not recognised : " + dateObject.getClass().getName());
        }
        dateString = (String)dateObject;
        if (dateString.length() == 0) {
            return null;
        }
        if (startOfPeriod) {
            return DateUtil.formatDateStartPeriod(dateString);
        }
        return DateUtil.formatDateEndPeriod(dateString);
    }

    private static Date formatDateStartPeriod(String value) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        TIME_FORMAT timeFormat = DateUtil.getTimeFormatOfDate(value);
        DateFormat df = null;
        String formatValue = null;
        String[] split = null;
        int quarter = 0;
        Calendar cal = null;
        switch (timeFormat) {
            case DATE: {
                formatValue = value;
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case DATE_TIME: {
                break;
            }
            case HALF_OF_YEAR: {
                split = value.split("-B");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-01-01";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-07-01";
                    }
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case HOUR: {
                formatValue = value;
                if (formatValue.length() == 16) {
                    df = new SimpleDateFormat("yyyy-MM-dd'T'HH");
                    break;
                }
                if (formatValue.length() == 16) {
                    df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm");
                    break;
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case MONTH: {
                formatValue = value + "-01";
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case QUARTER_OF_YEAR: {
                split = value.split("-Q");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-01-01";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-04-01";
                        break;
                    }
                    case 3: {
                        formatValue = split[0] + "-07-01";
                        break;
                    }
                    case 4: {
                        formatValue = split[0] + "-10-01";
                    }
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case THIRD_OF_YEAR: {
                break;
            }
            case WEEK: {
                split = value.split("-W");
                cal = DateUtil.getCalendar();
                cal.set(7, 2);
                cal.set(1, Integer.parseInt(split[0]));
                cal.set(3, Integer.parseInt(split[1]));
                return cal.getTime();
            }
            case YEAR: {
                formatValue = value + "-01-01";
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            default: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "formatting date of type " + (Object)((Object)timeFormat));
            }
        }
        try {
            return df.parse(formatValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Date formatDateEndPeriod(String value) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        TIME_FORMAT timeFormat = DateUtil.getTimeFormatOfDate(value);
        DateFormat df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
        String formatValue = null;
        String[] split = null;
        int days = 0;
        int quarter = 0;
        Calendar cal = null;
        switch (timeFormat) {
            case DATE: {
                formatValue = value;
                df = DateUtil.getDateFormatter("yyyy-MM-dd");
                break;
            }
            case DATE_TIME: {
                break;
            }
            case HALF_OF_YEAR: {
                split = value.split("-B");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-06-30T23:59:59";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-12-31T23:59:59";
                    }
                }
                break;
            }
            case HOUR: {
                formatValue = value;
                if (formatValue.length() == 16) {
                    df = new SimpleDateFormat("yyyy-MM-dd'T'HH");
                    break;
                }
                if (formatValue.length() == 16) {
                    df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm");
                    break;
                }
                df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case MONTH: {
                split = value.split("-");
                cal = DateUtil.getCalendar();
                cal.clear();
                cal.set(1, Integer.parseInt(split[0]));
                cal.set(2, Integer.parseInt(split[1]) - 1);
                days = cal.getActualMaximum(5);
                formatValue = value + "-" + days + "T23:59:59";
                break;
            }
            case QUARTER_OF_YEAR: {
                split = value.split("-Q");
                quarter = Integer.parseInt(split[1]);
                switch (quarter) {
                    case 1: {
                        formatValue = split[0] + "-03-31T23:59:59";
                        break;
                    }
                    case 2: {
                        formatValue = split[0] + "-06-30T23:59:59";
                        break;
                    }
                    case 3: {
                        formatValue = split[0] + "-09-30T23:59:59";
                        break;
                    }
                    case 4: {
                        formatValue = split[0] + "-12-31T23:59:59";
                    }
                }
                break;
            }
            case THIRD_OF_YEAR: {
                break;
            }
            case WEEK: {
                split = value.split("-W");
                cal = DateUtil.getCalendar();
                cal.set(7, 1);
                cal.set(1, Integer.parseInt(split[0]));
                cal.set(3, Integer.parseInt(split[1]));
                return cal.getTime();
            }
            case YEAR: {
                formatValue = value + "-12-31T23:59:59";
                break;
            }
            default: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, "formatting date of type " + (Object)((Object)timeFormat));
            }
        }
        try {
            return df.parse(formatValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TIME_FORMAT getTimeFormatOfDate(String dateStr) {
        if (dateStr == null) {
            throw new IllegalArgumentException("Could not determine date format, date null");
        }
        if (dateStr.endsWith("Z")) {
            dateStr = dateStr.substring(0, dateStr.length() - 1);
        }
        if (xmlYearlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.YEAR;
        }
        if (xmlSemiAnnualPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HALF_OF_YEAR;
        }
        if (xmlQuarterlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.QUARTER_OF_YEAR;
        }
        if (xmlMonthlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.MONTH;
        }
        if (xmlWeeklyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.WEEK;
        }
        if (xmlDailyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.DATE;
        }
        if (xmlHourlyPattern.matcher(dateStr).matches()) {
            return TIME_FORMAT.HOUR;
        }
        throw new ValidationException(ExceptionCode.INVALID_DATE_FORMAT, dateStr);
    }

    public static String formatDate(Date dt) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        if (dt == null) {
            return null;
        }
        DateFormat df = DateUtil.getDateTimeFormat();
        return df.format(dt);
    }

    public static DateFormat getDateTimeFormat() {
        return DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss");
    }

    public static DateFormat getDateFormat() {
        return DateUtil.getDateFormatter("yyyy-MM-dd");
    }

    public static DateFormat getYearFormat() {
        return DateUtil.getDateFormatter("yyyy");
    }

    public static DateFormat getMonthFormat() {
        return DateUtil.getDateFormatter("yyyy-MM");
    }

    public static DateFormat geWeekFormat() {
        return DateUtil.getDateFormatter("yyyy-ww");
    }

    public static List<String> createTimeValues(Date dateFrom, Date dateTo, TIME_FORMAT format) {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        ArrayList<String> returnList = new ArrayList<String>();
        switch (format) {
            case DATE: {
                DateUtil.iterateDailyValues(dateFrom, dateTo, returnList);
                break;
            }
            case DATE_TIME: {
                throw new UnsupportedException(ExceptionCode.UNSUPPORTED, new Object[]{format});
            }
            case HALF_OF_YEAR: {
                DateUtil.iterateHalfYearlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case HOUR: {
                DateUtil.iterateHourlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case MONTH: {
                DateUtil.iterateMonthlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case QUARTER_OF_YEAR: {
                DateUtil.iterateQuarterlyValues(dateFrom, dateTo, returnList);
                break;
            }
            case THIRD_OF_YEAR: {
                DateUtil.iterateThirdOfYearValues(dateFrom, dateTo, returnList);
                break;
            }
            case WEEK: {
                DateUtil.iterateWeeklyValues(dateFrom, dateTo, returnList);
                break;
            }
            case YEAR: {
                DateUtil.iterateYearlyValues(dateFrom, dateTo, returnList);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported time format : " + (Object)((Object)format));
            }
        }
        return returnList;
    }

    private static void iterateDailyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 5, 1, TIME_FORMAT.DATE);
    }

    private static void iterateHalfYearlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 2, 6, TIME_FORMAT.HALF_OF_YEAR);
    }

    private static void iterateHourlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 10, 1, TIME_FORMAT.HOUR);
    }

    private static void iterateMonthlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateMonthValue(dateFrom, dateTo, returnList, 1, TIME_FORMAT.MONTH);
    }

    private static void iterateQuarterlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateMonthValue(dateFrom, dateTo, returnList, 3, TIME_FORMAT.QUARTER_OF_YEAR);
    }

    private static void iterateThirdOfYearValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 2, 4, TIME_FORMAT.THIRD_OF_YEAR);
    }

    private static void iterateWeeklyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateWeekValue(dateFrom, dateTo, returnList, 1, TIME_FORMAT.WEEK);
    }

    private static void iterateYearlyValues(Date dateFrom, Date dateTo, List<String> returnList) {
        DateUtil.iterateDateValues(dateFrom, dateTo, returnList, 1, 1, TIME_FORMAT.YEAR);
    }

    private static void iterateDateValues(Date dateFrom, Date dateTo, List<String> returnList, int duration, int number, TIME_FORMAT format) {
        Calendar cal = DateUtil.getCalendar();
        cal.setTime(dateFrom);
        Calendar calTo = DateUtil.getCalendar();
        calTo.setTime(dateTo);
        while (!cal.getTime().after(calTo.getTime())) {
            returnList.add(DateUtil.formatDate(cal.getTime(), format));
            cal.add(duration, number);
        }
    }

    private static void iterateMonthValue(Date dateFrom, Date dateTo, List<String> returnList, int number, TIME_FORMAT format) {
        LocalDate dateTimeFrom = new LocalDate((Object)dateFrom, DateTimeZone.UTC);
        LocalDate dateTimeTo = new LocalDate((Object)dateTo, DateTimeZone.UTC);
        while (!dateTimeFrom.isAfter((ReadablePartial)dateTimeTo)) {
            returnList.add(DateUtil.formatDate(dateTimeFrom.toDate(), format));
            dateTimeFrom = dateTimeFrom.plusMonths(number);
        }
    }

    private static void iterateWeekValue(Date dateFrom, Date dateTo, List<String> returnList, int number, TIME_FORMAT format) {
        LocalDate dateTimeFrom = new LocalDate((Object)dateFrom, DateTimeZone.UTC);
        LocalDate dateTimeTo = new LocalDate((Object)dateTo, DateTimeZone.UTC);
        while (!dateTimeFrom.isAfter((ReadablePartial)dateTimeTo)) {
            returnList.add(DateUtil.formatDate(dateTimeFrom.toDate(), format));
            dateTimeFrom = dateTimeFrom.plusWeeks(number);
        }
    }

    public static String formatDate(Date date, TIME_FORMAT format) {
        DateFormat df = null;
        String formatted = null;
        switch (format) {
            case DATE: {
                df = DateUtil.getDateFormat();
                return df.format(date);
            }
            case DATE_TIME: {
                df = DateUtil.getDateTimeFormat();
                return df.format(date);
            }
            case YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar();
                cal.setTime(date);
                return formatted;
            }
            case HALF_OF_YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar();
                cal.setTime(date);
                formatted = cal.get(2) <= 6 ? formatted + "-B1" : formatted + "-B2";
                return formatted;
            }
            case HOUR: {
                df = DateUtil.getDateTimeFormat();
                return df.format(date);
            }
            case MONTH: {
                df = DateUtil.getMonthFormat();
                return df.format(date);
            }
            case QUARTER_OF_YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar();
                cal.setTime(date);
                formatted = cal.get(2) <= 2 ? formatted + "-Q1" : (cal.get(2) <= 5 ? formatted + "-Q2" : (cal.get(2) <= 8 ? formatted + "-Q3" : formatted + "-Q4"));
                return formatted;
            }
            case THIRD_OF_YEAR: {
                df = DateUtil.getYearFormat();
                formatted = df.format(date);
                Calendar cal = DateUtil.getCalendar();
                cal.setTime(date);
                formatted = cal.get(2) <= 3 ? formatted + "-T1" : (cal.get(2) <= 7 ? formatted + "-T2" : formatted + "-T3");
                return formatted;
            }
            case WEEK: {
                LocalDate dateTimeFrom = new LocalDate((Object)date, DateTimeZone.UTC);
                int weekNum = dateTimeFrom.getWeekOfWeekyear();
                int year = dateTimeFrom.getWeekyear();
                formatted = year + "-W" + weekNum;
                return formatted;
            }
        }
        return null;
    }

    public static String getDateTimeStringNow() {
        DateFormat df = DateUtil.getDateFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date d = new Date();
        return df.format(d);
    }

    public static Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setMinimalDaysInFirstWeek(4);
        cal.setFirstDayOfWeek(2);
        return cal;
    }

    public static Date parseDate(String date, String dateFormat) {
        DateFormat sdf = DateUtil.getDateFormatter(dateFormat);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static DateFormat getDateFormatter(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf.getCalendar().setMinimalDaysInFirstWeek(4);
        sdf.getCalendar().setFirstDayOfWeek(2);
        return sdf;
    }
}

